/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.connector.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.rocketpowered.common.PunishmentType;
import net.rocketpowered.connector.capability.ServerRocketHandle;
import net.rocketpowered.connector.commands.RocketCommands;
import net.rocketpowered.connector.commands.arguments.InstantArgument;
import net.rocketpowered.sdk.interf.GameServerInterface;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class PunishCommands {
    private static final String PREFIX = "r";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        Arrays.stream(PunishmentType.values()).map(PunishCommands::command).forEach(arg_0 -> dispatcher.register(arg_0));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> command(PunishmentType type) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)(PREFIX + type.getName())).requires(RocketCommands.hasPermissions(type.getPermission().bits()))).then(PunishCommands.args(type));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> args(PunishmentType type) {
        return ((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)GameProfileArgument.m_94584_()).executes(context -> PunishCommands.punishPlayers((CommandSourceStack)context.getSource(), GameProfileArgument.m_94590_((CommandContext)context, (String)"targets"), null, null, type))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"expiresAt", (ArgumentType)InstantArgument.instant()).executes(context -> PunishCommands.punishPlayers((CommandSourceStack)context.getSource(), GameProfileArgument.m_94590_((CommandContext)context, (String)"targets"), (Instant)context.getArgument("expiresAt", Instant.class), null, type))).then(Commands.m_82129_((String)"reason", (ArgumentType)MessageArgument.m_96832_()).executes(context -> PunishCommands.punishPlayers((CommandSourceStack)context.getSource(), GameProfileArgument.m_94590_((CommandContext)context, (String)"targets"), (Instant)context.getArgument("expiresAt", Instant.class), MessageArgument.m_96835_((CommandContext)context, (String)"reason"), type))));
    }

    private static int punishPlayers(CommandSourceStack source, Collection<GameProfile> profiles, @Nullable Instant expiresAt, @Nullable Component reason, PunishmentType type) throws CommandSyntaxException {
        ServerRocketHandle punisher = ServerRocketHandle.get(source.m_81373_()).orElseThrow(() -> ((SimpleCommandExceptionType)RocketCommands.ROCKET_UNAVAILABLE_ERROR).create());
        GameServerInterface gateway = punisher.getGateway();
        Flux.fromIterable(profiles).map(GameProfile::getId).flatMap(arg_0 -> ((GameServerInterface)gateway).getUser(arg_0)).flatMap(user -> gateway.punish(user.id(), punisher.getUserId(), null, reason == null ? null : reason.getString(), expiresAt, type).doOnError(error -> source.m_81377_().execute(() -> source.m_81352_((Component)new TranslatableComponent("commands.rocket.punish.failure", new Object[]{error.getMessage()})))).onErrorResume(__ -> Mono.empty()).doOnSuccess(punishment -> source.m_81377_().execute(() -> source.m_81354_((Component)new TranslatableComponent("commands.rocket.punish.success", new Object[]{user.displayName(), ComponentUtils.m_130748_((Component)new TextComponent(punishment.id().toHexString()).m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, punishment.id().toHexString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("chat.copy.click"))).m_131138_(punishment.id().toHexString())))}), true)))).subscribeOn(Schedulers.boundedElastic()).subscribe();
        return 1;
    }
}

