package net.rocketpowered.connector.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.network.NetworkEvent;
import net.rocketpowered.connector.capability.RocketHandle;

public record SyncHandleMessage(int entityId, FriendlyByteBuf data) {

  public void encode(FriendlyByteBuf out) {
    out.writeVarInt(this.entityId);
    out.writeBytes(this.data);
    this.data.release();
  }

  public static SyncHandleMessage decode(FriendlyByteBuf in) {
    return new SyncHandleMessage(in.readVarInt(),
        new FriendlyByteBuf(in.readBytes(in.readableBytes())));
  }

  public boolean handle(Supplier<NetworkEvent.Context> context) {
    context.get().enqueueWork(() -> LogicalSidedProvider.CLIENTWORLD
        .get(context.get().getDirection().getReceptionSide())
        .map(level -> level.getEntity(this.entityId))
        .ifPresent(entity -> entity.getCapability(RocketHandle.CAPABILITY)
            .ifPresent(player -> {
              player.readSyncData(this.data);
              ((Player) entity).refreshDisplayName();
            })));
    this.data.release();
    return true;
  }
}
