package net.rocketpowered.connector.network;

import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.rocketpowered.connector.RocketConnector;

public class NetworkManager {

  public static final String PROTOCOL_VERSION = "0";
  public static final SimpleChannel channel = NetworkRegistry.newSimpleChannel(
      new ResourceLocation(RocketConnector.ID, "main"), () -> PROTOCOL_VERSION,
      PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);

  public static void registerMessages() {
    channel.messageBuilder(RegisterHandleMessage.class, 0x00, NetworkDirection.PLAY_TO_CLIENT)
        .encoder(RegisterHandleMessage::encode)
        .decoder(RegisterHandleMessage::decode)
        .consumer(RegisterHandleMessage::handle)
        .add();
    channel.messageBuilder(SyncHandleMessage.class, 0x01, NetworkDirection.PLAY_TO_CLIENT)
        .encoder(SyncHandleMessage::encode)
        .decoder(SyncHandleMessage::decode)
        .consumer(SyncHandleMessage::handle)
        .add();
    channel.messageBuilder(InvalidateHandleMessage.class, 0x02, NetworkDirection.PLAY_TO_CLIENT)
        .encoder(InvalidateHandleMessage::encode)
        .decoder(InvalidateHandleMessage::decode)
        .consumer(InvalidateHandleMessage::handle)
        .add();
  }
}
