package net.rocketpowered.connector.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.rocketpowered.connector.RocketConnector;

public record InvalidateHandleMessage(UUID playerId) {

  public void encode(FriendlyByteBuf out) {
    out.writeUUID(this.playerId);
  }

  public static InvalidateHandleMessage decode(FriendlyByteBuf in) {
    return new InvalidateHandleMessage(in.readUUID());
  }

  public boolean handle(Supplier<NetworkEvent.Context> context) {
    RocketConnector.getInstance().getClientDist().invalidateHandle(this.playerId);
    return true;
  }
}
