package net.rocketpowered.connector.commands.arguments;

import java.util.Arrays;
import java.util.Collection;
import org.bson.types.ObjectId;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.network.chat.TranslatableComponent;

public class ObjectIdArgument implements ArgumentType<ObjectId> {

  public static final SimpleCommandExceptionType invalidObjectIdError =
      new SimpleCommandExceptionType(new TranslatableComponent("argument.rocket.objectid.invalid"));

  private static final Collection<String> EXAMPLES = Arrays.asList("6284f4ed5af9975fd203fb40");

  public static ObjectIdArgument objectId() {
    return new ObjectIdArgument();
  }

  @Override
  public ObjectId parse(StringReader reader) throws CommandSyntaxException {
    var hexString = reader.readUnquotedString();
    if (!ObjectId.isValid(hexString)) {
      throw invalidObjectIdError.create();
    }
    return new ObjectId(hexString);
  }

  @Override
  public Collection<String> getExamples() {
    return EXAMPLES;
  }
}
