package net.rocketpowered.connector.client;

import org.bson.types.ObjectId;
import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig {

  public final ForgeConfigSpec.ConfigValue<String> projectId;
  public final ForgeConfigSpec.BooleanValue bypassAuthentication;

  public ClientConfig(ForgeConfigSpec.Builder builder) {
    this.projectId = builder.define("projectId", "",
        obj -> obj instanceof String && ObjectId.isValid((String) obj));
    this.bypassAuthentication = builder.define("bypassAuthentication", () -> false);
  }
}
