/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.connector.client;

import com.mojang.logging.LogUtils;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.rocketpowered.common.Guild;
import net.rocketpowered.common.network.Connection;
import net.rocketpowered.common.network.protocol.v1.login.GameClientHelloMessage;
import net.rocketpowered.common.network.protocol.v1.login.GameClientLoginMessage;
import net.rocketpowered.common.network.protocol.v1.login.GameClientReadyMessage;
import net.rocketpowered.common.network.protocol.v1.login.GameClientSecretMessage;
import net.rocketpowered.connector.ModDist;
import net.rocketpowered.connector.RocketConnector;
import net.rocketpowered.connector.capability.CommonRocketHandle;
import net.rocketpowered.connector.capability.RocketHandle;
import net.rocketpowered.connector.client.ClientConfig;
import net.rocketpowered.sdk.network.protocol.gameclient.GameClientConnectionHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.bson.types.ObjectId;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ClientDist
implements ModDist {
    private static final ForgeConfigSpec configSpec;
    public static final ClientConfig config;
    private static final Logger logger;
    private final Minecraft minecraft;
    private final Map<UUID, LazyOptional<RocketHandle>> playerHandles = new ConcurrentHashMap<UUID, LazyOptional<RocketHandle>>();

    public ClientDist() {
        this.minecraft = Minecraft.m_91087_();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::handleClientSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)configSpec);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void handleClientSetup(FMLClientSetupEvent event) {
        RocketConnector.getInstance().init();
    }

    @Override
    public Mono<Void> login(Connection connection) {
        return Mono.from((Publisher)connection.send((Object)new GameClientHelloMessage())).cast(GameClientSecretMessage.class).publishOn(Schedulers.boundedElastic()).handle((message, sink) -> {
            if (((Boolean)ClientDist.config.bypassAuthentication.get()).booleanValue()) {
                sink.complete();
                return;
            }
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                messageDigest.update(message.encodedSecretKey());
                String serverId = new BigInteger(messageDigest.digest()).toString(16);
                this.minecraft.m_91108_().joinServer(this.minecraft.m_91094_().m_92548_(), this.minecraft.m_91094_().m_92547_(), serverId);
                sink.complete();
            }
            catch (Exception e) {
                sink.error((Throwable)e);
            }
        }).then(Mono.from((Publisher)connection.send((Object)new GameClientLoginMessage(new ObjectId((String)ClientDist.config.projectId.get()), this.minecraft.m_91094_().m_92546_())))).cast(GameClientReadyMessage.class).map(GameClientReadyMessage::user).doOnNext(user -> logger.info("Successfully logged in to Rocket as: {}", (Object)user.displayName())).map(user -> new GameClientConnectionHandler(connection, user)).doOnNext(arg_0 -> ((Connection)connection).loadConnectionHandler(arg_0)).then();
    }

    public void registerHandle(UUID playerId, ObjectId userId) {
        this.playerHandles.put(playerId, (LazyOptional<RocketHandle>)LazyOptional.of(() -> new CommonRocketHandle(userId)));
    }

    public void invalidateHandle(UUID playerId) {
        this.playerHandles.remove(playerId);
    }

    @SubscribeEvent
    public void handleRenderNameplate(RenderNameplateEvent event) {
        Optional<Guild> entityGuild;
        RocketHandle clientHandle;
        RocketHandle handle = (RocketHandle)event.getEntity().getCapability(RocketHandle.CAPABILITY).orElse(null);
        RocketHandle rocketHandle = clientHandle = this.minecraft.f_91074_ == null ? null : (RocketHandle)this.minecraft.f_91074_.getCapability(RocketHandle.CAPABILITY).orElse(null);
        if (handle != null && clientHandle != null && (entityGuild = handle.getGuild()).isPresent() && clientHandle.getGuild().equals(entityGuild)) {
            event.setContent((Component)event.getContent().m_6881_().m_130940_(ChatFormatting.GREEN));
        }
    }

    @SubscribeEvent
    public void handleAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof AbstractClientPlayer) {
            final AbstractClientPlayer player = (AbstractClientPlayer)object;
            event.addCapability(new ResourceLocation("rocketconnector", "handle"), new ICapabilityProvider(){

                public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
                    return cap == RocketHandle.CAPABILITY ? ClientDist.this.playerHandles.getOrDefault(player.m_142081_(), (LazyOptional<RocketHandle>)LazyOptional.empty()).cast() : LazyOptional.empty();
                }
            });
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        configSpec = (ForgeConfigSpec)specPair.getRight();
        config = (ClientConfig)specPair.getLeft();
        logger = LogUtils.getLogger();
    }
}

