/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.connector.capability;

import java.util.Optional;
import java.util.SortedSet;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.rocketpowered.common.Guild;
import net.rocketpowered.common.ProjectPermission;
import net.rocketpowered.common.Role;
import org.bson.types.ObjectId;

public interface RocketHandle {
    public static final Capability<RocketHandle> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<RocketHandle>(){});

    public ObjectId getUserId();

    public SortedSet<Role> getRoles();

    public long getPermissions();

    default public boolean hasPermissions(long permissions) {
        return ProjectPermission.ADMINISTRATOR.contains(this.getPermissions()) || (this.getPermissions() & permissions) == permissions;
    }

    public Optional<Guild> getGuild();

    public boolean isMuted();

    default public Component formatTabListName(Component tabListName) {
        MutableComponent prefix = TextComponent.f_131282_.m_6881_();
        if (!this.getRoles().isEmpty()) {
            prefix.m_7220_((Component)new TextComponent(this.getRoles().last().name())).m_130946_(" ");
        }
        this.getGuild().ifPresent(guild -> prefix.m_7220_((Component)new TextComponent(guild.tag()).m_130946_(" ")));
        return prefix.m_7220_(tabListName);
    }

    default public Component formatDisplayName(Component displayName) {
        MutableComponent prefix = TextComponent.f_131282_.m_6881_();
        if (!this.getRoles().isEmpty()) {
            prefix.m_7220_((Component)new TextComponent(this.getRoles().last().name())).m_130946_(" ");
        }
        return prefix.m_7220_(displayName);
    }

    public void writeSyncData(FriendlyByteBuf var1);

    public void readSyncData(FriendlyByteBuf var1);

    public boolean requiresSync();
}

