/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.connector.capability;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.rocketpowered.common.Guild;
import net.rocketpowered.common.Punishment;
import net.rocketpowered.common.Role;
import net.rocketpowered.common.SocialProfile;
import net.rocketpowered.connector.capability.RocketHandle;
import org.bson.types.ObjectId;

public class CommonRocketHandle
implements RocketHandle {
    private final ObjectId userId;
    protected final SortedSet<Role> roles = new TreeSet<Role>();
    @Nullable
    protected SocialProfile socialProfile;
    @Nullable
    protected Punishment mute;
    private boolean requiresSync;
    protected long computedPermissions = 0L;

    public CommonRocketHandle(ObjectId userId) {
        this.userId = userId;
    }

    protected void setChanged() {
        this.requiresSync = true;
    }

    @Override
    public ObjectId getUserId() {
        return this.userId;
    }

    @Override
    public SortedSet<Role> getRoles() {
        return this.roles;
    }

    @Override
    public long getPermissions() {
        return this.computedPermissions;
    }

    @Override
    public Optional<Guild> getGuild() {
        return this.socialProfile == null ? Optional.empty() : Optional.ofNullable(this.socialProfile.guild());
    }

    @Override
    public boolean isMuted() {
        return this.mute != null && this.mute.isActive();
    }

    @Override
    public void writeSyncData(FriendlyByteBuf out) {
        out.m_130130_(this.roles.size());
        for (Role role : this.roles) {
            role.encode((ByteBuf)out);
        }
        if (this.socialProfile == null) {
            out.writeBoolean(true);
        } else {
            out.writeBoolean(false);
            this.socialProfile.encode((ByteBuf)out);
        }
        if (this.mute == null) {
            out.writeBoolean(true);
        } else {
            out.writeBoolean(false);
            this.mute.encode((ByteBuf)out);
        }
        this.requiresSync = false;
    }

    @Override
    public void readSyncData(FriendlyByteBuf in) {
        this.roles.clear();
        this.computedPermissions = 0L;
        int size = in.m_130242_();
        for (int i = 0; i < size; ++i) {
            Role role = Role.decode((ByteBuf)in);
            this.roles.add(role);
            this.computedPermissions |= role.permissions();
        }
        this.socialProfile = in.readBoolean() ? null : SocialProfile.decode((ByteBuf)in);
        this.mute = in.readBoolean() ? null : Punishment.decode((ByteBuf)in);
    }

    @Override
    public boolean requiresSync() {
        return this.requiresSync;
    }
}

