package net.rocketpowered.connector.server;

import java.nio.file.Path;
import java.util.Properties;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.dedicated.Settings;

public class RocketProperties extends Settings<RocketProperties> {

  public final String serverId = this.get("server-id", "");
  public final String serverToken = this.get("server-token", "");
  public final boolean addToServerList = this.get("add-to-server-list", false);
  public final boolean displayMutedMessage = this.get("display-muted-message", true);

  private RocketProperties(Properties properties) {
    super(properties);
  }

  public static RocketProperties fromFile(Path path) {
    return new RocketProperties(loadFromFile(path));
  }

  @Override
  protected RocketProperties reload(RegistryAccess registries, Properties properties) {
    return new RocketProperties(properties);
  }
}
