package net.rocketpowered.connector.network;

import java.util.UUID;
import java.util.function.Supplier;
import org.bson.types.ObjectId;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.rocketpowered.connector.RocketConnector;
import net.rocketpowered.common.util.ByteBufUtil;

public record RegisterHandleMessage(UUID playerId, ObjectId userId) {

  public void encode(FriendlyByteBuf out) {
    out.writeUUID(this.playerId);
    ByteBufUtil.writeObjectId(this.userId, out);
  }

  public static RegisterHandleMessage decode(FriendlyByteBuf in) {
    return new RegisterHandleMessage(in.readUUID(), ByteBufUtil.readObjectId(in));
  }

  public boolean handle(Supplier<NetworkEvent.Context> context) {
    RocketConnector.getInstance().getClientDist().registerHandle(this.playerId, this.userId);
    return true;
  }
}
