package net.rocketpowered.connector.commands;

import java.util.function.Predicate;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.rocketpowered.connector.capability.RocketHandle;
import net.rocketpowered.connector.server.commands.PardonCommand;
import net.rocketpowered.connector.server.commands.PunishCommands;

public class RocketCommands {

  public static final SimpleCommandExceptionType ROCKET_UNAVAILABLE_ERROR =
      new SimpleCommandExceptionType(new TranslatableComponent("rocket.message.unavailable"));

  public static void register(CommandDispatcher<CommandSourceStack> dispatcher,
      Commands.CommandSelection selection) {
    // Only on dedicated servers
    if (selection != Commands.CommandSelection.INTEGRATED) {
      PunishCommands.register(dispatcher);
      PardonCommand.register(dispatcher);
    }
  }

  public static Predicate<CommandSourceStack> hasPermissions(long permissions) {
    return source -> source.getEntity() instanceof Player player
        && player.getCapability(RocketHandle.CAPABILITY)
            .map(handle -> handle.hasPermissions(permissions))
            .orElse(false);
  }
}
