package net.rocketpowered.connector.capability;

import java.util.Optional;
import java.util.SortedSet;
import org.bson.types.ObjectId;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.rocketpowered.common.Guild;
import net.rocketpowered.common.ProjectPermission;
import net.rocketpowered.common.Role;

public interface RocketHandle {

  Capability<RocketHandle> CAPABILITY = CapabilityManager.get(new CapabilityToken<>() {});

  ObjectId getUserId();

  SortedSet<Role> getRoles();

  long getPermissions();

  default boolean hasPermissions(long permissions) {
    return ProjectPermission.ADMINISTRATOR.contains(this.getPermissions())
        || (this.getPermissions() & permissions) == permissions;
  }

  Optional<Guild> getGuild();

  boolean isMuted();

  default Component formatTabListName(Component tabListName) {
    var prefix = TextComponent.EMPTY.copy();
    if (!this.getRoles().isEmpty()) {
      prefix
          .append(new TextComponent(this.getRoles().last().name()))
          .append(" ");
    }
    this.getGuild().ifPresent(guild -> prefix.append(new TextComponent(guild.tag()).append(" ")));
    return prefix.append(tabListName);
  }

  default Component formatDisplayName(Component displayName) {
    var prefix = TextComponent.EMPTY.copy();
    if (!this.getRoles().isEmpty()) {
      prefix
          .append(new TextComponent(this.getRoles().last().name()))
          .append(" ");
    }
    return prefix.append(displayName);
  }

  void writeSyncData(FriendlyByteBuf out);

  void readSyncData(FriendlyByteBuf in);

  boolean requiresSync();
}
