/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.AbstractSniHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AsyncMapping;
import io.netty.util.DomainWildcardMappingBuilder;
import io.netty.util.Mapping;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import java.util.Map;
import reactor.netty.tcp.SslProvider;

final class SniProvider {
    final AsyncMapping<String, SslProvider> mappings;

    void addSniHandler(Channel channel, boolean sslDebug) {
        ChannelPipeline pipeline = channel.pipeline();
        if (pipeline.get("reactor.left.nonSslRedirectDetector") != null) {
            pipeline.addAfter("reactor.left.nonSslRedirectDetector", "reactor.left.sslHandler", (ChannelHandler)((Object)this.newSniHandler()));
        } else {
            pipeline.addFirst("reactor.left.sslHandler", (ChannelHandler)((Object)this.newSniHandler()));
        }
        SslProvider.addSslReadHandler(pipeline, sslDebug);
    }

    SniProvider(AsyncMapping<String, SslProvider> mappings) {
        this.mappings = mappings;
    }

    SniProvider(Map<String, SslProvider> confPerDomainName, SslProvider defaultSslProvider) {
        DomainWildcardMappingBuilder mappingsSslProviderBuilder = new DomainWildcardMappingBuilder((Object)defaultSslProvider);
        confPerDomainName.forEach((arg_0, arg_1) -> ((DomainWildcardMappingBuilder)mappingsSslProviderBuilder).add(arg_0, arg_1));
        this.mappings = new AsyncMappingAdapter((Mapping<String, SslProvider>)mappingsSslProviderBuilder.build());
    }

    SniHandler newSniHandler() {
        return new SniHandler(this.mappings);
    }

    static final class SniHandler
    extends AbstractSniHandler<SslProvider> {
        final AsyncMapping<String, SslProvider> mappings;

        SniHandler(AsyncMapping<String, SslProvider> mappings) {
            this.mappings = mappings;
        }

        protected Future<SslProvider> lookup(ChannelHandlerContext ctx, String hostname) {
            return this.mappings.map((Object)hostname, ctx.executor().newPromise());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onLookupComplete(ChannelHandlerContext ctx, String hostname, Future<SslProvider> future) {
            if (!future.isSuccess()) {
                Throwable cause = future.cause();
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new DecoderException("failed to get the SslContext for " + hostname, cause);
            }
            SslProvider sslProvider = (SslProvider)future.getNow();
            SslHandler sslHandler = null;
            try {
                sslHandler = sslProvider.getSslContext().newHandler(ctx.alloc());
                sslProvider.configure(sslHandler);
                ctx.pipeline().replace((ChannelHandler)((Object)this), SslHandler.class.getName(), (ChannelHandler)sslHandler);
                sslHandler = null;
            }
            catch (Throwable cause) {
                PlatformDependent.throwException((Throwable)cause);
            }
            finally {
                if (sslHandler != null) {
                    ReferenceCountUtil.safeRelease((Object)sslHandler.engine());
                }
            }
        }
    }

    static final class AsyncMappingAdapter
    implements AsyncMapping<String, SslProvider> {
        final Mapping<String, SslProvider> mapping;

        AsyncMappingAdapter(Mapping<String, SslProvider> mapping) {
            this.mapping = mapping;
        }

        public Future<SslProvider> map(String input, Promise<SslProvider> promise) {
            try {
                return promise.setSuccess((Object)((SslProvider)this.mapping.map((Object)input)));
            }
            catch (Throwable cause) {
                return promise.setFailure(cause);
            }
        }
    }
}

