/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.util.IllegalReferenceCountException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.netty.ByteBufFlux;
import reactor.netty.ReactorNetty;

public class ByteBufMono
extends MonoOperator<ByteBuf, ByteBuf> {
    public final Mono<ByteBuffer> asByteBuffer() {
        return this.handle((bb, sink) -> {
            try {
                sink.next(bb.nioBuffer());
            }
            catch (IllegalReferenceCountException e) {
                sink.complete();
            }
        });
    }

    public final Mono<byte[]> asByteArray() {
        return this.handle((bb, sink) -> {
            try {
                byte[] bytes = new byte[bb.readableBytes()];
                bb.readBytes(bytes);
                sink.next(bytes);
            }
            catch (IllegalReferenceCountException e) {
                sink.complete();
            }
        });
    }

    public final Mono<String> asString() {
        return this.asString(Charset.defaultCharset());
    }

    public final Mono<String> asString(Charset charset) {
        Objects.requireNonNull(charset, "charset");
        return this.handle((bb, sink) -> {
            try {
                sink.next(bb.readCharSequence(bb.readableBytes(), charset).toString());
            }
            catch (IllegalReferenceCountException e) {
                sink.complete();
            }
        });
    }

    public final Mono<InputStream> asInputStream() {
        return this.handle((bb, sink) -> {
            try {
                sink.next(new ReleasingInputStream((ByteBuf)bb));
            }
            catch (IllegalReferenceCountException e) {
                sink.complete();
            }
        });
    }

    public static ByteBufMono fromString(Publisher<? extends String> source) {
        return ByteBufMono.fromString(source, Charset.defaultCharset(), ByteBufAllocator.DEFAULT);
    }

    public static ByteBufMono fromString(Publisher<? extends String> source, Charset charset, ByteBufAllocator allocator) {
        Objects.requireNonNull(allocator, "allocator");
        Objects.requireNonNull(charset, "charset");
        return ByteBufMono.maybeFuse(Mono.from(ReactorNetty.publisherOrScalarMap(source, s2 -> {
            ByteBuf buffer = allocator.buffer();
            buffer.writeCharSequence((CharSequence)s2, charset);
            return buffer;
        }, l -> {
            ByteBuf buffer = allocator.buffer();
            for (String s2 : l) {
                buffer.writeCharSequence((CharSequence)s2, charset);
            }
            return buffer;
        })));
    }

    public final ByteBufMono retain() {
        return ByteBufMono.maybeFuse(this.doOnNext(ByteBuf::retain));
    }

    @Override
    public void subscribe(CoreSubscriber<? super ByteBuf> actual) {
        this.source.subscribe(actual);
    }

    ByteBufMono(Mono<?> source) {
        super(source.map(ByteBufFlux.bytebufExtractor));
    }

    static ByteBufMono maybeFuse(Mono<?> source) {
        if (source instanceof Fuseable) {
            return new ByteBufMonoFuseable(source);
        }
        return new ByteBufMono(source);
    }

    static final class ReleasingInputStream
    extends ByteBufInputStream {
        final ByteBuf bb;
        volatile int closed;
        static final AtomicIntegerFieldUpdater<ReleasingInputStream> CLOSE = AtomicIntegerFieldUpdater.newUpdater(ReleasingInputStream.class, "closed");

        ReleasingInputStream(ByteBuf bb) {
            super(bb.retain());
            this.bb = bb;
        }

        public void close() throws IOException {
            if (CLOSE.compareAndSet(this, 0, 1)) {
                try {
                    super.close();
                }
                finally {
                    this.bb.release();
                }
            }
        }
    }

    static final class ByteBufMonoFuseable
    extends ByteBufMono
    implements Fuseable {
        ByteBufMonoFuseable(Mono<?> source) {
            super(source);
        }
    }
}

