/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.sdk.util;

import java.net.InetSocketAddress;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TreeSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ServiceRecord(int priority, int weight, int port, String host) implements Comparable<ServiceRecord>
{
    private static final Logger logger = LoggerFactory.getLogger(ServiceRecord.class);

    public ServiceRecord(int priority, int weight, int port, String host) {
        this.priority = priority;
        this.weight = weight;
        this.port = port;
        this.host = host.replaceAll("\\\\.$", "");
    }

    public InetSocketAddress toInetSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    @Override
    public int compareTo(ServiceRecord o) {
        int result = Integer.compare(this.priority, o.priority);
        return result == 0 ? Integer.compare(o.weight, this.weight) : result;
    }

    public static ServiceRecord fromString(String input) {
        String[] splitted = input.split(" ");
        return new ServiceRecord(Integer.parseInt(splitted[0]), Integer.parseInt(splitted[1]), Integer.parseInt(splitted[2]), splitted[3]);
    }

    public static Optional<ServiceRecord> resolve(String recordName) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        env.put("java.naming.provider.url", "dns:");
        TreeSet<ServiceRecord> sortedRecords = new TreeSet<ServiceRecord>();
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            Attributes attrs = ctx.getAttributes(recordName, new String[]{"SRV"});
            NamingEnumeration<?> services = attrs.get("srv").getAll();
            while (services.hasMore()) {
                sortedRecords.add(ServiceRecord.fromString((String)services.next()));
            }
        }
        catch (NoSuchElementException | NamingException e) {
            logger.error("Failed to resolve service", (Throwable)e);
            return Optional.empty();
        }
        return sortedRecords.isEmpty() ? Optional.empty() : Optional.of((ServiceRecord)sortedRecords.last());
    }
}

