/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.sdk.network.protocol.gameserver;

import java.time.Instant;
import net.rocketpowered.common.Punishment;
import net.rocketpowered.common.PunishmentType;
import net.rocketpowered.common.network.Connection;
import net.rocketpowered.common.network.protocol.v1.gameserver.GameServerProtocol;
import net.rocketpowered.common.network.protocol.v1.gameserver.GetActivePunishmentsMessage;
import net.rocketpowered.common.network.protocol.v1.gameserver.GetPunishmentsFeedMessage;
import net.rocketpowered.common.network.protocol.v1.gameserver.IncrementStatValueMessage;
import net.rocketpowered.common.network.protocol.v1.gameserver.PardonMessage;
import net.rocketpowered.common.network.protocol.v1.gameserver.PunishMessage;
import net.rocketpowered.common.network.protocol.v1.gameserver.SetStatValueMessage;
import net.rocketpowered.common.network.protocol.v1.gameserver.UpdateStatusMessage;
import net.rocketpowered.common.util.Protocol;
import net.rocketpowered.sdk.interf.GameServerInterface;
import net.rocketpowered.sdk.network.protocol.common.CommonConnectionHandler;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GameServerConnectionHandler
extends CommonConnectionHandler
implements GameServerInterface {
    public GameServerConnectionHandler(Connection connection) {
        super(connection);
    }

    @Override
    public Protocol getProtocol() {
        return GameServerProtocol.INSTANCE;
    }

    @Override
    public Mono<Integer> incrementStatValue(ObjectId statId, ObjectId userId) {
        return Mono.from(this.connection.send(new IncrementStatValueMessage(statId, userId))).cast(Integer.class);
    }

    @Override
    public Mono<Void> setStatValue(ObjectId statId, ObjectId userId, int value) {
        return Mono.when(this.connection.send(new SetStatValueMessage(statId, userId, value)));
    }

    @Override
    public Flux<Punishment> getActivePunishments(ObjectId userId) {
        return Flux.from(this.connection.send(new GetActivePunishmentsMessage(userId))).cast(Punishment.class);
    }

    @Override
    public Flux<Punishment> getPunishmentFeed(ObjectId userId) {
        return Flux.from(this.connection.send(new GetPunishmentsFeedMessage(userId))).cast(Punishment.class);
    }

    @Override
    public Mono<Punishment> punish(ObjectId userId, ObjectId punisherId, ObjectId serverId, String reason, Instant expiresAt, PunishmentType type) {
        return Mono.from(this.connection.send(new PunishMessage(userId, punisherId, serverId, reason, expiresAt, type))).cast(Punishment.class);
    }

    @Override
    public Mono<Void> updateStatus(String host, int port, @Nullable String gameId) {
        return Mono.when(this.connection.send(new UpdateStatusMessage(host, port, gameId)));
    }

    @Override
    public Mono<Punishment> pardon(ObjectId userId, ObjectId punishmentId) {
        return Mono.from(this.connection.send(new PardonMessage(userId, punishmentId))).cast(Punishment.class);
    }
}

