/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.sdk.network.protocol.gameclient;

import java.time.Duration;
import net.rocketpowered.common.GameServerStatus;
import net.rocketpowered.common.Guild;
import net.rocketpowered.common.GuildEvent;
import net.rocketpowered.common.GuildMember;
import net.rocketpowered.common.GuildRank;
import net.rocketpowered.common.User;
import net.rocketpowered.common.network.Connection;
import net.rocketpowered.common.network.PayloadHandlerDispatcher;
import net.rocketpowered.common.network.protocol.v1.gameclient.AcceptGuildInviteMessage;
import net.rocketpowered.common.network.protocol.v1.gameclient.CreateGuildMessage;
import net.rocketpowered.common.network.protocol.v1.gameclient.DeclineGuildInviteMessage;
import net.rocketpowered.common.network.protocol.v1.gameclient.DeleteGuildMessage;
import net.rocketpowered.common.network.protocol.v1.gameclient.GameClientProtocol;
import net.rocketpowered.common.network.protocol.v1.gameclient.GetGameServersMessage;
import net.rocketpowered.common.network.protocol.v1.gameclient.GetGuildEventFeedMessage;
import net.rocketpowered.common.network.protocol.v1.gameclient.GetGuildMemberFeedMessage;
import net.rocketpowered.common.network.protocol.v1.gameclient.GetGuildMembersMessage;
import net.rocketpowered.common.network.protocol.v1.gameclient.IncrementStatValueMessage;
import net.rocketpowered.common.network.protocol.v1.gameclient.KickGuildMemberMessage;
import net.rocketpowered.common.network.protocol.v1.gameclient.LeaveGuildMessage;
import net.rocketpowered.common.network.protocol.v1.gameclient.RenameGuildMessage;
import net.rocketpowered.common.network.protocol.v1.gameclient.SendGuildInviteMessage;
import net.rocketpowered.common.network.protocol.v1.gameclient.SetGuildMemberRankMessage;
import net.rocketpowered.common.network.protocol.v1.gameclient.SetStatValueMessage;
import net.rocketpowered.common.network.protocol.v1.gameclient.TransferGuildOwnershipMessage;
import net.rocketpowered.common.util.Protocol;
import net.rocketpowered.sdk.interf.GameClientInterface;
import net.rocketpowered.sdk.network.protocol.common.CommonConnectionHandler;
import org.bson.types.ObjectId;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GameClientConnectionHandler
extends CommonConnectionHandler
implements GameClientInterface {
    private static final Duration CACHE_LIFETIME = Duration.ofMinutes(5L);
    private static final PayloadHandlerDispatcher<GameClientConnectionHandler> payloadHandlerDispatcher = new PayloadHandlerDispatcher();
    private final User user;
    private final Flux<GuildEvent> guildEvents;

    public GameClientConnectionHandler(Connection connection, User user) {
        super(connection);
        this.user = user;
        this.guildEvents = Flux.from(connection.send(new GetGuildEventFeedMessage())).cast(GuildEvent.class).publish().refCount(1, CACHE_LIFETIME);
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public User user() {
        return this.user;
    }

    @Override
    public Protocol getProtocol() {
        return GameClientProtocol.INSTANCE;
    }

    @Override
    public <T> Publisher<?> handlePayload(Connection connection, T payload) {
        return payloadHandlerDispatcher.handlePayload(this, payload);
    }

    @Override
    public Flux<GuildEvent> getGuildEventFeed() {
        return this.guildEvents;
    }

    @Override
    public Flux<GuildMember> getGuildMembers(ObjectId guildId) {
        return Flux.from(this.connection.send(new GetGuildMembersMessage(guildId))).cast(GuildMember.class);
    }

    @Override
    public Flux<GuildMember> getGuildMemberFeed(ObjectId userId) {
        return Flux.from(this.connection.send(new GetGuildMemberFeedMessage(userId))).cast(GuildMember.class);
    }

    @Override
    public Mono<Guild> createGuild(String name, String tag) {
        return Mono.from(this.connection.send(new CreateGuildMessage(name, tag))).cast(Guild.class);
    }

    @Override
    public Mono<Void> deleteGuild() {
        return Mono.when(this.connection.send(new DeleteGuildMessage()));
    }

    @Override
    public Mono<Void> sendGuildInvite(ObjectId userId) {
        return Mono.when(this.connection.send(new SendGuildInviteMessage(userId)));
    }

    @Override
    public Mono<Void> acceptGuildInvite(ObjectId guildId) {
        return Mono.when(this.connection.send(new AcceptGuildInviteMessage(guildId)));
    }

    @Override
    public Mono<Void> declineGuildInvite(ObjectId guildId) {
        return Mono.when(this.connection.send(new DeclineGuildInviteMessage(guildId)));
    }

    @Override
    public Mono<Void> kickGuildMember(ObjectId userId) {
        return Mono.when(this.connection.send(new KickGuildMemberMessage(userId)));
    }

    @Override
    public Mono<Void> renameGuild(String name) {
        return Mono.when(this.connection.send(new RenameGuildMessage(name)));
    }

    @Override
    public Mono<Void> transferGuildOwnership(ObjectId userId) {
        return Mono.when(this.connection.send(new TransferGuildOwnershipMessage(userId)));
    }

    @Override
    public Mono<Void> setGuildMemberRank(ObjectId userId, GuildRank rank) {
        return Mono.when(this.connection.send(new SetGuildMemberRankMessage(userId, rank)));
    }

    @Override
    public Mono<Void> leaveGuild() {
        return Mono.when(this.connection.send(new LeaveGuildMessage()));
    }

    @Override
    public Mono<Integer> incrementStatValue(ObjectId statId) {
        return Mono.from(this.connection.send(new IncrementStatValueMessage(statId))).cast(Integer.class);
    }

    @Override
    public Mono<Void> setStatValue(ObjectId statId, int value) {
        return Mono.when(this.connection.send(new SetStatValueMessage(statId, value)));
    }

    @Override
    public Flux<GameServerStatus> getGameServers() {
        return Flux.from(this.connection.send(new GetGameServersMessage())).cast(GameServerStatus.class);
    }
}

