/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.sdk.network.protocol.common;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.rocketpowered.common.GameProfile;
import net.rocketpowered.common.Role;
import net.rocketpowered.common.SocialProfile;
import net.rocketpowered.common.User;
import net.rocketpowered.common.UserPresence;
import net.rocketpowered.common.network.Connection;
import net.rocketpowered.common.network.ConnectionHandler;
import net.rocketpowered.common.network.protocol.v1.common.GetRoleFeedMessage;
import net.rocketpowered.common.network.protocol.v1.common.GetSocialProfileFeedMessage;
import net.rocketpowered.common.network.protocol.v1.common.GetStatValueMessage;
import net.rocketpowered.common.network.protocol.v1.common.GetUserIdByMinecraftIdMessage;
import net.rocketpowered.common.network.protocol.v1.common.GetUserIdByMinecraftNameMessage;
import net.rocketpowered.common.network.protocol.v1.gameclient.GetUserMessage;
import net.rocketpowered.common.network.protocol.v1.gameclient.GetUserPresenceFeedMessage;
import net.rocketpowered.common.network.protocol.v1.gameserver.GetGameProfileFeed;
import net.rocketpowered.sdk.interf.GatewayInterface;
import org.bson.types.ObjectId;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public abstract class CommonConnectionHandler
implements ConnectionHandler,
GatewayInterface {
    public static final Duration CACHE_LIFETIME = Duration.ofMinutes(5L);
    protected final Connection connection;
    private final AsyncLoadingCache<String, ObjectId> userIdByMinecraftNameCache;
    private final AsyncLoadingCache<UUID, ObjectId> userIdByMinecraftIdCache;
    private final AsyncLoadingCache<ObjectId, User> userByIdCache;
    private final Map<ObjectId, Flux<UserPresence>> userPresenceCache = new ConcurrentHashMap<ObjectId, Flux<UserPresence>>();
    private final Map<ObjectId, Flux<SocialProfile>> socialProfileCache = new ConcurrentHashMap<ObjectId, Flux<SocialProfile>>();
    private final Map<ObjectId, Flux<GameProfile>> gameProfileCache = new ConcurrentHashMap<ObjectId, Flux<GameProfile>>();
    private final Map<ObjectId, Flux<Role>> roleCache = new ConcurrentHashMap<ObjectId, Flux<Role>>();

    protected CommonConnectionHandler(Connection connection) {
        this.connection = connection;
        this.userByIdCache = Caffeine.newBuilder().expireAfterAccess(CACHE_LIFETIME).buildAsync((key, executor) -> Mono.from(this.connection.send(new GetUserMessage((ObjectId)key))).cast(User.class).subscribeOn(Schedulers.fromExecutor(executor)).toFuture());
        this.userIdByMinecraftNameCache = Caffeine.newBuilder().expireAfterAccess(CACHE_LIFETIME).buildAsync((key, executor) -> Mono.from(this.connection.send(new GetUserIdByMinecraftNameMessage((String)key))).cast(ObjectId.class).subscribeOn(Schedulers.fromExecutor(executor)).toFuture());
        this.userIdByMinecraftIdCache = Caffeine.newBuilder().expireAfterAccess(CACHE_LIFETIME).buildAsync((key, executor) -> Mono.from(this.connection.send(new GetUserIdByMinecraftIdMessage((UUID)key))).cast(ObjectId.class).subscribeOn(Schedulers.fromExecutor(executor)).toFuture());
    }

    public void clearUserCaches(ObjectId userId) {
        this.socialProfileCache.remove(userId);
        this.gameProfileCache.remove(userId);
    }

    @Override
    public Mono<User> getUser(ObjectId userId) {
        return Mono.fromFuture(this.userByIdCache.get(userId));
    }

    @Override
    public Mono<ObjectId> getUserId(UUID minecraftId) {
        return Mono.fromFuture(this.userIdByMinecraftIdCache.get(minecraftId));
    }

    @Override
    public Mono<ObjectId> getUserId(String minecraftName) {
        return Mono.fromFuture(this.userIdByMinecraftNameCache.get(minecraftName));
    }

    @Override
    public Flux<UserPresence> getUserPresenceFeed(ObjectId userId) {
        return this.userPresenceCache.computeIfAbsent(userId, __ -> Flux.from(this.connection.send(new GetUserPresenceFeedMessage(userId))).cast(UserPresence.class).doOnCancel(() -> this.userPresenceCache.remove(userId)).replay(1).refCount(1, CACHE_LIFETIME));
    }

    @Override
    public Flux<SocialProfile> getSocialProfileFeed(ObjectId userId) {
        return this.socialProfileCache.computeIfAbsent(userId, __ -> Flux.from(this.connection.send(new GetSocialProfileFeedMessage(userId))).cast(SocialProfile.class).doOnCancel(() -> this.socialProfileCache.remove(userId)).replay(1).refCount(1, CACHE_LIFETIME));
    }

    @Override
    public Flux<GameProfile> getGameProfileFeed(ObjectId userId) {
        return this.gameProfileCache.computeIfAbsent(userId, __ -> Flux.from(this.connection.send(new GetGameProfileFeed(userId))).cast(GameProfile.class).doOnCancel(() -> this.gameProfileCache.remove(userId)).replay(1).refCount(1, CACHE_LIFETIME));
    }

    @Override
    public Flux<Role> getRoleFeed(ObjectId roleId) {
        return this.roleCache.computeIfAbsent(roleId, __ -> Flux.from(this.connection.send(new GetRoleFeedMessage(roleId))).cast(Role.class).doOnCancel(() -> this.roleCache.remove(roleId)).replay(1).refCount(1, CACHE_LIFETIME));
    }

    @Override
    public Mono<Integer> getStatValue(ObjectId statId, ObjectId userId) {
        return Mono.from(this.connection.send(new GetStatValueMessage(statId, userId))).cast(Integer.class);
    }

    @Override
    public Mono<Void> onClose() {
        return this.connection.onClose();
    }
}

