/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.sdk.interf;

import net.rocketpowered.common.GameProfile;
import net.rocketpowered.common.GameServerStatus;
import net.rocketpowered.common.Guild;
import net.rocketpowered.common.GuildEvent;
import net.rocketpowered.common.GuildMember;
import net.rocketpowered.common.GuildRank;
import net.rocketpowered.common.SocialProfile;
import net.rocketpowered.common.User;
import net.rocketpowered.sdk.interf.GatewayInterface;
import org.bson.types.ObjectId;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface GameClientInterface
extends GatewayInterface {
    public User user();

    default public Flux<SocialProfile> getSocialProfileFeed() {
        return this.getSocialProfileFeed(this.user().id());
    }

    default public Flux<GameProfile> getGameProfileFeed() {
        return this.getGameProfileFeed(this.user().id());
    }

    default public Mono<Integer> getStatValue(ObjectId statId) {
        return this.getStatValue(statId, this.user().id());
    }

    public Flux<GuildEvent> getGuildEventFeed();

    public Flux<GuildMember> getGuildMembers(ObjectId var1);

    default public Flux<GuildMember> getGuildMemberFeed() {
        return this.getGuildMemberFeed(this.user().id());
    }

    public Flux<GuildMember> getGuildMemberFeed(ObjectId var1);

    public Mono<Guild> createGuild(String var1, String var2);

    public Mono<Void> deleteGuild();

    public Mono<Void> sendGuildInvite(ObjectId var1);

    public Mono<Void> acceptGuildInvite(ObjectId var1);

    public Mono<Void> declineGuildInvite(ObjectId var1);

    public Mono<Void> kickGuildMember(ObjectId var1);

    public Mono<Void> renameGuild(String var1);

    public Mono<Void> transferGuildOwnership(ObjectId var1);

    public Mono<Void> setGuildMemberRank(ObjectId var1, GuildRank var2);

    public Mono<Void> leaveGuild();

    public Mono<Integer> incrementStatValue(ObjectId var1);

    public Mono<Void> setStatValue(ObjectId var1, int var2);

    public Flux<GameServerStatus> getGameServers();
}

