/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.sdk;

import java.util.Objects;
import java.util.Optional;
import net.rocketpowered.common.network.Connection;
import net.rocketpowered.sdk.interf.GameClientInterface;
import net.rocketpowered.sdk.interf.GameServerInterface;
import net.rocketpowered.sdk.interf.GatewayInterface;
import net.rocketpowered.sdk.network.ConnectionManager;
import org.jetbrains.annotations.ApiStatus;
import reactor.core.publisher.Flux;

public class Rocket {
    private static ConnectionManager connectionManager;

    @ApiStatus.Internal
    public static void setConnectionManager(ConnectionManager connectionManager) {
        Rocket.connectionManager = connectionManager;
    }

    public static Flux<GameClientInterface> gameClientInterfaceFeed() {
        return Rocket.getInterfaceFeed(GameClientInterface.class);
    }

    public static Flux<GameServerInterface> gameServerInterfaceFeed() {
        return Rocket.getInterfaceFeed(GameServerInterface.class);
    }

    private static <I extends GatewayInterface> Flux<I> getInterfaceFeed(Class<I> clazz) {
        Objects.requireNonNull(connectionManager, "connectionManager cannot be null");
        return connectionManager.getConnectionFeed().map(Connection::getConnectionHandler).ofType(clazz);
    }

    public static Optional<GameClientInterface> gameClientInterface() {
        return Rocket.getInterface(GameClientInterface.class);
    }

    public static Optional<GameServerInterface> gameServerInterface() {
        return Rocket.getInterface(GameServerInterface.class);
    }

    private static <I extends GatewayInterface> Optional<I> getInterface(Class<I> clazz) {
        Objects.requireNonNull(connectionManager, "connectionManager cannot be null");
        return connectionManager.getConnection().map(Connection::getConnectionHandler).filter(clazz::isInstance).map(clazz::cast);
    }
}

