/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.connector.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.rocketpowered.connector.capability.ServerRocketHandle;
import net.rocketpowered.connector.commands.RocketCommands;
import net.rocketpowered.connector.commands.arguments.ObjectIdArgument;
import org.bson.types.ObjectId;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class PardonCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"pardon").requires(source -> source.m_81373_() instanceof Player && ServerRocketHandle.get(source.m_81373_()).isPresent())).then(Commands.m_82129_((String)"punishment_id", (ArgumentType)ObjectIdArgument.objectId()).executes(context -> PardonCommand.pardon((CommandSourceStack)context.getSource(), (ObjectId)context.getArgument("punishment_id", ObjectId.class)))));
    }

    private static int pardon(CommandSourceStack source, ObjectId punishmentId) throws CommandSyntaxException {
        ServerRocketHandle handle = ServerRocketHandle.get(source.m_81373_()).orElseThrow(() -> ((SimpleCommandExceptionType)RocketCommands.ROCKET_UNAVAILABLE_ERROR).create());
        handle.getGateway().pardon(handle.getUserId(), punishmentId).switchIfEmpty(Mono.empty().doOnSuccess(__ -> source.m_81377_().execute(() -> source.m_81352_((Component)new TranslatableComponent("commands.rocket.pardon.unknown_punishment"))))).doOnError(error -> source.m_81377_().execute(() -> source.m_81352_((Component)new TranslatableComponent("commands.rocket.pardon.failure", new Object[]{error.getMessage()})))).onErrorResume(__ -> Mono.empty()).doOnNext(punishment -> source.m_81377_().execute(() -> source.m_81354_((Component)new TranslatableComponent("commands.rocket.pardon.success", new Object[]{punishment.punished().displayName()}), true))).subscribeOn(Schedulers.boundedElastic()).subscribe();
        return 1;
    }
}

