/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.connector.network;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.network.NetworkEvent;
import net.rocketpowered.connector.capability.RocketHandle;

public record SyncHandleMessage(int entityId, FriendlyByteBuf data) {
    public void encode(FriendlyByteBuf out) {
        out.m_130130_(this.entityId);
        out.writeBytes((ByteBuf)this.data);
        this.data.release();
    }

    public static SyncHandleMessage decode(FriendlyByteBuf in) {
        return new SyncHandleMessage(in.m_130242_(), new FriendlyByteBuf(in.readBytes(in.readableBytes())));
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ((Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)context.get()).getDirection().getReceptionSide())).map(level -> level.m_6815_(this.entityId)).ifPresent(entity -> entity.getCapability(RocketHandle.CAPABILITY).ifPresent(player -> {
            player.readSyncData(this.data);
            ((Player)entity).refreshDisplayName();
        })));
        this.data.release();
        return true;
    }
}

