/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.connector.commands.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.TranslatableComponent;

public class InstantArgument
implements ArgumentType<Instant> {
    private static final Collection<String> EXAMPLES = List.of("0d", "0h", "0m", "0s", "0");
    private static final SimpleCommandExceptionType invalidUnitError = new SimpleCommandExceptionType((Message)new TranslatableComponent("argument.rocket.instant.invalid_unit"));
    private static final Map<String, TemporalUnit> units = Map.of("d", ChronoUnit.DAYS, "h", ChronoUnit.HOURS, "m", ChronoUnit.MINUTES, "s", ChronoUnit.SECONDS, "", ChronoUnit.SECONDS);

    public static InstantArgument instant() {
        return new InstantArgument();
    }

    public Instant parse(StringReader reader) throws CommandSyntaxException {
        long amount = reader.readLong();
        TemporalUnit unit = units.get(reader.readUnquotedString());
        if (unit == null) {
            throw invalidUnitError.create();
        }
        return Instant.now().plus(Duration.of(amount, unit));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader reader = new StringReader(builder.getRemaining());
        try {
            reader.readLong();
        }
        catch (CommandSyntaxException e) {
            return builder.buildFuture();
        }
        return SharedSuggestionProvider.m_82970_(units.keySet(), (SuggestionsBuilder)builder.createOffset(builder.getStart() + reader.getCursor()));
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

