/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.connector;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.JarVersionLookupHandler;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.rocketpowered.connector.CommonConfig;
import net.rocketpowered.connector.ModDist;
import net.rocketpowered.connector.capability.RocketHandle;
import net.rocketpowered.connector.client.ClientDist;
import net.rocketpowered.connector.commands.RocketCommands;
import net.rocketpowered.connector.commands.arguments.InstantArgument;
import net.rocketpowered.connector.commands.arguments.ObjectIdArgument;
import net.rocketpowered.connector.network.NetworkManager;
import net.rocketpowered.connector.server.ServerDist;
import net.rocketpowered.sdk.Rocket;
import net.rocketpowered.sdk.network.ConnectionManager;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

@Mod(value="rocketconnector")
public class RocketConnector {
    public static final String ID = "rocketconnector";
    public static final String VERSION = JarVersionLookupHandler.getImplementationVersion(RocketConnector.class).orElse("[version]");
    private static final Logger logger = LogUtils.getLogger();
    private static final ForgeConfigSpec configSpec;
    public static final CommonConfig config;
    private static RocketConnector instance;
    private final ModDist modDist;
    private final Path modPath;
    private final ConnectionManager connectionManager;

    public RocketConnector() {
        instance = this;
        this.modPath = FMLPaths.CONFIGDIR.get().resolve(ID);
        if (!Files.exists(this.modPath, new LinkOption[0])) {
            try {
                Files.createDirectory(this.modPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        this.modDist = (ModDist)DistExecutor.safeRunForDist(() -> ClientDist::new, () -> ServerDist::new);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::handleCommonSetup);
        modEventBus.addListener(this::handleRegisterCapabilities);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)configSpec);
        NetworkManager.registerMessages();
        this.connectionManager = new ConnectionManager(() -> RocketConnector.config.serviceName.get(), this.modDist::login);
        Rocket.setConnectionManager(this.connectionManager);
    }

    private void handleCommonSetup(FMLCommonSetupEvent event) {
        ArgumentTypes.m_121601_((String)"rocketconnector:instant", InstantArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(InstantArgument::instant));
        ArgumentTypes.m_121601_((String)"rocketconnector:objectid", ObjectIdArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(ObjectIdArgument::objectId));
    }

    private void handleRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(RocketHandle.class);
    }

    public void init() {
        if (!((Boolean)RocketConnector.config.enabled.get()).booleanValue()) {
            logger.info("Rocket Connector disabled by config.");
            return;
        }
        if (!this.modDist.setup()) {
            logger.warn("Rocket Connector setup failed, check console for other warnings.");
            return;
        }
        logger.info("Initializing Rocket Connector");
        this.connectionManager.init();
    }

    public ModDist getModDist() {
        return this.modDist;
    }

    public ClientDist getClientDist() {
        ModDist modDist = this.modDist;
        if (modDist instanceof ClientDist) {
            ClientDist clientDist = (ClientDist)modDist;
            return clientDist;
        }
        throw new IllegalStateException("Cannot access client from server dist");
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public Path getModPath() {
        return this.modPath;
    }

    @SubscribeEvent
    public void handleRegisterCommands(RegisterCommandsEvent event) {
        RocketCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getEnvironment());
    }

    @SubscribeEvent
    public void handleLivingAttack(LivingAttackEvent event) {
        if (event.getSource().m_7639_() instanceof Player && event.getEntity() instanceof Player) {
            RocketHandle attacker = (RocketHandle)event.getSource().m_7639_().getCapability(RocketHandle.CAPABILITY).orElse(null);
            RocketHandle attacked = (RocketHandle)event.getEntity().getCapability(RocketHandle.CAPABILITY).orElse(null);
            if (attacker != null && attacked != null && attacker.getGuild().isPresent() && attacker.getGuild().equals(attacked.getGuild())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void handlePlayerNameFormat(PlayerEvent.NameFormat event) {
        event.getPlayer().getCapability(RocketHandle.CAPABILITY).map(handle -> handle.formatDisplayName(event.getDisplayname())).ifPresent(arg_0 -> ((PlayerEvent.NameFormat)event).setDisplayname(arg_0));
    }

    public static RocketConnector getInstance() {
        return instance;
    }

    public static boolean isActive() {
        return (Boolean)RocketConnector.config.enabled.get() != false && (!FMLEnvironment.dist.isDedicatedServer() || ServerLifecycleHooks.getCurrentServer().m_129797_());
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        configSpec = (ForgeConfigSpec)specPair.getRight();
        config = (CommonConfig)specPair.getLeft();
    }
}

