/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.common.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.rocketpowered.common.util.Protocol;

public class SimpleProtocol
implements Protocol {
    private final Map<Byte, Codec<?>> indexToCodec = new Byte2ObjectOpenHashMap();
    private final Map<Class<?>, Codec<?>> typeToCodec = new Object2ObjectOpenHashMap();
    private final ByteBufAllocator byteBufAllocator;
    private final boolean preferDirect;

    public SimpleProtocol() {
        this(true);
    }

    public SimpleProtocol(boolean preferDirect) {
        this(ByteBufAllocator.DEFAULT, preferDirect);
    }

    public SimpleProtocol(ByteBufAllocator byteBufAllocator, boolean preferDirect) {
        this.byteBufAllocator = byteBufAllocator;
        this.preferDirect = preferDirect;
    }

    public <T> CodecBuilder<T> codecBuilder(int index, Class<T> type) {
        return new CodecBuilder<T>(index, type);
    }

    @Override
    public ByteBuf allocateByteBuf() {
        return this.preferDirect ? this.byteBufAllocator.ioBuffer() : this.byteBufAllocator.heapBuffer();
    }

    @Override
    public <T> void encode(T payload, ByteBuf out) {
        Codec<?> entry = this.typeToCodec.get(payload.getClass());
        if (entry == null) {
            throw new EncoderException("[" + this.toString() + "] Unknown payload type " + payload.getClass().getName());
        }
        out.writeByte((int)entry.index);
        entry.encoder.encode(payload, out, this);
    }

    @Override
    public <T> T decode(ByteBuf buf) {
        byte index = buf.readByte();
        Codec<?> codec = this.indexToCodec.get(index);
        if (codec != null) {
            return codec.decoder.decode(buf, this);
        }
        throw new DecoderException("[" + this.toString() + "] Unknown payload index " + index);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public class CodecBuilder<T> {
        private final byte index;
        private final Class<T> type;
        private Encoder<T> encoder;
        private Decoder<T> decoder;

        private CodecBuilder(int index, Class<T> type) {
            if (index < 0 || index > 255) {
                throw new IllegalArgumentException("Index must be an unsigned byte (0 - 256)");
            }
            this.index = (byte)(index & 0xFF);
            this.type = type;
        }

        public CodecBuilder<T> noop(Supplier<T> value) {
            return this.encoder((T x, ByteBuf y, Protocol z) -> {}).decoder((ByteBuf x, Protocol y) -> value.get());
        }

        public CodecBuilder<T> encoder(Encoder.Compact<T> encoder) {
            return this.encoder((Encoder<T>)encoder);
        }

        public CodecBuilder<T> encoder(Encoder.ReverseCompact<T> encoder) {
            return this.encoder((Encoder<T>)encoder);
        }

        public CodecBuilder<T> encoder(Encoder<T> encoder) {
            this.encoder = encoder;
            return this;
        }

        public CodecBuilder<T> decoder(Decoder.Compact<T> decoder) {
            this.decoder = decoder;
            return this;
        }

        public CodecBuilder<T> decoder(Decoder<T> decoder) {
            this.decoder = decoder;
            return this;
        }

        public SimpleProtocol register() {
            Codec<T> entry = new Codec<T>(this.index, this.encoder, this.decoder);
            if (SimpleProtocol.this.indexToCodec.containsKey(this.index)) {
                throw new IllegalArgumentException("Object with index " + this.index + " already registered");
            }
            SimpleProtocol.this.indexToCodec.put(this.index, entry);
            if (SimpleProtocol.this.typeToCodec.containsKey(this.type)) {
                throw new IllegalArgumentException("Object of type " + this.type.getName() + " already registered");
            }
            SimpleProtocol.this.typeToCodec.put(this.type, entry);
            return SimpleProtocol.this;
        }
    }

    private static class Codec<T> {
        private final byte index;
        private final Encoder<T> encoder;
        private final Decoder<T> decoder;

        public Codec(byte index, Encoder<T> encoder, Decoder<T> decoder) {
            this.index = index;
            this.encoder = encoder;
            this.decoder = decoder;
        }
    }

    @FunctionalInterface
    public static interface Encoder<T> {
        public void encode(T var1, ByteBuf var2, Protocol var3);

        public static interface ReverseCompact<T>
        extends Encoder<T> {
            @Override
            default public void encode(T value, ByteBuf out, Protocol protocol) {
                this.encode(out, value);
            }

            public void encode(ByteBuf var1, T var2);
        }

        public static interface Compact<T>
        extends Encoder<T> {
            @Override
            default public void encode(T value, ByteBuf out, Protocol protocol) {
                this.encode(value, out);
            }

            public void encode(T var1, ByteBuf var2);
        }
    }

    @FunctionalInterface
    public static interface Decoder<T> {
        public T decode(ByteBuf var1, Protocol var2);

        public static interface Compact<T>
        extends Decoder<T> {
            @Override
            default public T decode(ByteBuf in, Protocol protocol) {
                return this.decode(in);
            }

            public T decode(ByteBuf var1);
        }
    }
}

