/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.common.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Iterator;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collector;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.Nullable;

public class ByteBufUtil {
    public static <T> void writeIterator(Iterator<T> it, ByteBuf buf, BiConsumer<T, ByteBuf> encoder) {
        while (it.hasNext()) {
            buf.writeBoolean(true);
            encoder.accept(it.next(), buf);
        }
        buf.writeBoolean(false);
    }

    public static <T, A, R> R readIterator(ByteBuf buf, Function<ByteBuf, T> decoder, Collector<T, A, R> collector) {
        A result = collector.supplier().get();
        while (buf.readBoolean()) {
            collector.accumulator().accept(result, decoder.apply(buf));
        }
        return collector.finisher().apply(result);
    }

    public static Instant readInstant(ByteBuf buf) {
        return Instant.ofEpochSecond(ByteBufUtil.readVarLong(buf));
    }

    public static void writeInstant(Instant instant, ByteBuf buf) {
        ByteBufUtil.writeVarLong(instant.getEpochSecond(), buf);
    }

    @Nullable
    public static <T> T readNullable(ByteBuf buf, Function<ByteBuf, T> decoder) {
        return buf.readBoolean() ? null : (T)decoder.apply(buf);
    }

    public static <T> void writeNullable(ByteBuf buf, @Nullable T value, BiConsumer<T, ByteBuf> encoder) {
        if (value == null) {
            buf.writeBoolean(true);
        } else {
            buf.writeBoolean(false);
            encoder.accept(value, buf);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readObject(ByteBuf buf, Class<T> clazz) {
        try (ObjectInputStream in = new ObjectInputStream((InputStream)new ByteBufInputStream(buf));){
            Object object = in.readObject();
            T t = clazz.cast(object);
            return t;
        }
        catch (Throwable t2) {
            throw new EncoderException(t2);
        }
    }

    public static void writeObject(Object value, ByteBuf buf) {
        try (ObjectOutputStream out = new ObjectOutputStream((OutputStream)new ByteBufOutputStream(buf));){
            out.writeObject(value);
        }
        catch (Throwable t) {
            throw new EncoderException(t);
        }
    }

    public static <T extends Enum<T>> T readEnum(ByteBuf buf, Class<T> enumClass) {
        return (T)((Enum[])enumClass.getEnumConstants())[ByteBufUtil.readVarInt(buf)];
    }

    public static void writeEnum(Enum<?> value, ByteBuf buf) {
        ByteBufUtil.writeVarInt(value.ordinal(), buf);
    }

    public static ObjectId readObjectId(ByteBuf buf) {
        byte[] data = new byte[ByteBufUtil.readVarInt(buf)];
        buf.readBytes(data);
        return new ObjectId(data);
    }

    public static void writeObjectId(ObjectId value, ByteBuf buf) {
        byte[] data = value.toByteArray();
        ByteBufUtil.writeVarInt(data.length, buf);
        buf.writeBytes(data);
    }

    public static String readUtf8(ByteBuf buf) {
        int len = ByteBufUtil.readVarInt(buf);
        byte[] bytes = new byte[len];
        buf.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static void writeUtf8(String value, ByteBuf buf) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        if (bytes.length >= Short.MAX_VALUE) {
            throw new RuntimeException("Attempt to write a string with a length greater than Short.MAX_VALUE to ByteBuf!");
        }
        ByteBufUtil.writeVarInt(bytes.length, buf);
        buf.writeBytes(bytes);
    }

    public static int readVarInt(ByteBuf buf) {
        byte in;
        int out = 0;
        int bytes = 0;
        do {
            in = buf.readByte();
            out |= (in & 0x7F) << bytes++ * 7;
            if (bytes <= 5) continue;
            throw new RuntimeException("Attempt to read int bigger than allowed for a varint!");
        } while ((in & 0x80) == 128);
        return out;
    }

    public static void writeVarInt(int value, ByteBuf buf) {
        do {
            byte part = (byte)(value & 0x7F);
            if ((value >>>= 7) != 0) {
                part = (byte)(part | 0x80);
            }
            buf.writeByte((int)part);
        } while (value != 0);
    }

    public static long readVarLong(ByteBuf buf) {
        byte in;
        long out = 0L;
        int bytes = 0;
        do {
            in = buf.readByte();
            out |= (long)(in & 0x7F) << bytes++ * 7;
            if (bytes <= 10) continue;
            throw new RuntimeException("VarLong too big");
        } while ((in & 0x80) == 128);
        return out;
    }

    public static void writeVarLong(long value, ByteBuf buf) {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buf.writeByte((int)(value & 0x7FL) | 0x80);
            value >>>= 7;
        }
        buf.writeByte((int)value);
    }

    public static void writeUniqueId(UUID uuid, ByteBuf buf) {
        buf.writeLong(uuid.getMostSignificantBits());
        buf.writeLong(uuid.getLeastSignificantBits());
    }

    public static UUID readUniqueId(ByteBuf buf) {
        long mostSigBits = buf.readLong();
        long leastSigBits = buf.readLong();
        return new UUID(mostSigBits, leastSigBits);
    }

    public static void write(ByteBuf buf, OutputStream out) throws IOException {
        ByteBufUtil.write(buf, out::write);
    }

    public static void write(ByteBuf buf, DataOutput out) throws IOException {
        ByteBufUtil.write(buf, out::writeByte);
    }

    public static void write(ByteBuf buf, ByteWriter writer) throws IOException {
        int length = buf.readableBytes();
        writer.write(length >>> 24 & 0xFF);
        writer.write(length >>> 16 & 0xFF);
        writer.write(length >>> 8 & 0xFF);
        writer.write(length >>> 0 & 0xFF);
        while (buf.isReadable()) {
            writer.write(buf.readByte());
        }
    }

    public static ByteBuf read(InputStream in) throws IOException {
        return ByteBufUtil.read(in::read);
    }

    public static ByteBuf read(DataInput in) throws IOException {
        return ByteBufUtil.read(in::readByte);
    }

    public static ByteBuf read(ByteReader reader) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = reader.read();
        if ((ch1 | (ch2 = reader.read()) | (ch3 = reader.read()) | (ch4 = reader.read())) < 0) {
            throw new EOFException();
        }
        int length = (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        ByteBuf buf = Unpooled.buffer((int)length);
        for (int i = 0; i < length; ++i) {
            buf.writeByte(reader.read());
        }
        return buf;
    }

    public static int getVarIntSize(int input) {
        for (int i = 1; i < 5; ++i) {
            if ((input & -1 << i * 7) != 0) continue;
            return i;
        }
        return 5;
    }

    public static boolean hasVarInt(ByteBuf buf) {
        byte in;
        if (buf.readableBytes() > 5) {
            return true;
        }
        int idx = buf.readerIndex();
        do {
            if (buf.readableBytes() >= 1) continue;
            buf.readerIndex(idx);
            return false;
        } while (((in = buf.readByte()) & 0x80) != 0);
        buf.readerIndex(idx);
        return true;
    }

    public static byte[] toByteArray(ByteBuf buf) {
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        return bytes;
    }

    public static interface ByteWriter {
        public void write(int var1) throws IOException;
    }

    public static interface ByteReader {
        public int read() throws IOException;
    }
}

