/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.common.util;

import java.util.Collection;
import java.util.EnumSet;
import java.util.stream.Stream;

public interface BitValue {
    public static final long NILL = 0L;

    public long bits();

    default public long add(long bits) {
        return bits | this.bits();
    }

    default public long remove(long bits) {
        return bits & (this.bits() ^ 0xFFFFFFFFFFFFFFFFL);
    }

    default public boolean contains(long bits) {
        return (bits & this.bits()) == this.bits();
    }

    public static long encode(BitValue ... values) {
        return BitValue.encode(Stream.of(values));
    }

    public static long encode(Stream<? extends BitValue> values) {
        return values.mapToLong(BitValue::bits).reduce((result, permission) -> result | permission).orElse(0L);
    }

    public static <T extends Enum<T>> Collection<T> decode(long value, Class<T> type) {
        EnumSet<T> permissions = EnumSet.noneOf(type);
        for (Enum permission : EnumSet.allOf(type)) {
            if (!((BitValue)((Object)permission)).contains(value)) continue;
            permissions.add(permission);
        }
        return permissions;
    }
}

