/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.common.network.protocol.v1.gameserver;

import io.netty.buffer.ByteBuf;
import java.time.Instant;
import net.rocketpowered.common.PunishmentType;
import net.rocketpowered.common.util.ByteBufUtil;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.Nullable;

public record PunishMessage(ObjectId userId, ObjectId punisherId, @Nullable ObjectId serverId, @Nullable String reason, @Nullable Instant expiresAt, PunishmentType type) {
    public void encode(ByteBuf out) {
        ByteBufUtil.writeObjectId(this.userId, out);
        ByteBufUtil.writeObjectId(this.punisherId, out);
        ByteBufUtil.writeNullable(out, this.serverId, ByteBufUtil::writeObjectId);
        ByteBufUtil.writeNullable(out, this.reason, ByteBufUtil::writeUtf8);
        ByteBufUtil.writeNullable(out, this.expiresAt, ByteBufUtil::writeInstant);
        ByteBufUtil.writeEnum(this.type, out);
    }

    public static PunishMessage decode(ByteBuf in) {
        return new PunishMessage(ByteBufUtil.readObjectId(in), ByteBufUtil.readObjectId(in), ByteBufUtil.readNullable(in, ByteBufUtil::readObjectId), ByteBufUtil.readNullable(in, ByteBufUtil::readUtf8), ByteBufUtil.readNullable(in, ByteBufUtil::readInstant), ByteBufUtil.readEnum(in, PunishmentType.class));
    }
}

