/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.common.network;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.rocketpowered.common.network.ConnectionHandler;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class PayloadHandlerDispatcher<H extends ConnectionHandler> {
    private final Map<Class<?>, BiFunction<H, ?, Publisher<?>>> handlers = new Object2ObjectOpenHashMap();

    public <T> Publisher<?> handlePayload(H connectionHandler, T payload) {
        return Mono.fromSupplier(() -> this.handlers.get(payload.getClass())).switchIfEmpty(Mono.error(new IllegalStateException("No handler exists for " + payload.getClass().getName()))).flatMapMany(handler -> (Publisher)handler.apply(connectionHandler, payload));
    }

    public <T> PayloadHandlerDispatcher<H> registerHandler(Class<T> type, BiFunction<H, T, Publisher<?>> handler) {
        this.handlers.put(type, handler);
        return this;
    }
}

