/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.common.network;

import java.util.function.BiFunction;
import net.rocketpowered.common.network.Connection;
import net.rocketpowered.common.util.Protocol;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@FunctionalInterface
public interface ConnectionHandler {
    default public void load(Connection connection) {
    }

    default public void unload(Connection connection) {
    }

    default public <T> Publisher<?> handlePayload(Connection connection, T payload) {
        return Mono.empty();
    }

    public Protocol getProtocol();

    public static ConnectionHandler create(final Protocol protocol, final BiFunction<Connection, Object, Publisher<?>> payloadHandler) {
        return new ConnectionHandler(){

            @Override
            public <T> Publisher<?> handlePayload(Connection connection, T payload) {
                return (Publisher)payloadHandler.apply(connection, payload);
            }

            @Override
            public Protocol getProtocol() {
                return protocol;
            }
        };
    }
}

