/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.common;

import io.netty.buffer.ByteBuf;
import net.rocketpowered.common.MinecraftProfile;
import net.rocketpowered.common.util.ByteBufUtil;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.Nullable;

public record User(ObjectId id, @Nullable MinecraftProfile minecraftProfile) implements Comparable<User>
{
    public User(ObjectId id) {
        this(id, null);
    }

    public String displayName() {
        return this.minecraftProfile == null ? this.id.toHexString() : this.minecraftProfile.name();
    }

    public void encode(ByteBuf out) {
        ByteBufUtil.writeObjectId(this.id, out);
        if (this.minecraftProfile == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.minecraftProfile.encode(out);
        }
    }

    public static User decode(ByteBuf in) {
        ObjectId id = ByteBufUtil.readObjectId(in);
        boolean full = in.readBoolean();
        if (full) {
            return new User(id, MinecraftProfile.decode(in));
        }
        return new User(id);
    }

    public User withMinecraftProfile(MinecraftProfile minecraftProfile) {
        return new User(this.id, minecraftProfile);
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof User)) return false;
        User that = (User)obj;
        if (!that.id.equals(this.id)) return false;
        return true;
    }

    @Override
    public int compareTo(User o) {
        if (this.minecraftProfile != null && o.minecraftProfile != null) {
            return this.minecraftProfile.compareTo(o.minecraftProfile);
        }
        return this.id.compareTo(o.id);
    }
}

