/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.common;

import io.netty.buffer.ByteBuf;
import java.util.Set;
import java.util.stream.Collectors;
import net.rocketpowered.common.Guild;
import net.rocketpowered.common.GuildInvite;
import net.rocketpowered.common.User;
import net.rocketpowered.common.util.ByteBufUtil;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Mono;

public record SocialProfile(User user, @Nullable Guild guild, Set<GuildInvite> guildInvites) {
    public SocialProfile(User user, @Nullable Guild guild, Set<GuildInvite> guildInvites) {
        this.user = user;
        this.guild = guild;
        this.guildInvites = Set.copyOf(guildInvites);
    }

    public Mono<Guild> guildMono() {
        return Mono.justOrEmpty(this.guild);
    }

    public void encode(ByteBuf out) {
        this.user.encode(out);
        ByteBufUtil.writeNullable(out, this.guild, Guild::encode);
        ByteBufUtil.writeIterator(this.guildInvites.iterator(), out, GuildInvite::encode);
    }

    public static SocialProfile decode(ByteBuf in) {
        return new SocialProfile(User.decode(in), ByteBufUtil.readNullable(in, Guild::decode), ByteBufUtil.readIterator(in, GuildInvite::decode, Collectors.toSet()));
    }

    @Override
    public int hashCode() {
        return this.user.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SocialProfile)) return false;
        SocialProfile that = (SocialProfile)obj;
        if (!that.user.equals(this.user)) return false;
        return true;
    }
}

