/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.common;

import io.netty.buffer.ByteBuf;
import net.rocketpowered.common.util.ByteBufUtil;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.Nullable;

public record Role(@Nullable ObjectId id, ObjectId projectId, String name, int weight, long permissions) implements Comparable<Role>
{
    public void encode(ByteBuf out) {
        ByteBufUtil.writeNullable(out, this.id, ByteBufUtil::writeObjectId);
        ByteBufUtil.writeObjectId(this.projectId, out);
        ByteBufUtil.writeUtf8(this.name, out);
        ByteBufUtil.writeVarInt(this.weight, out);
        ByteBufUtil.writeVarLong(this.permissions, out);
    }

    public static Role decode(ByteBuf in) {
        return new Role(ByteBufUtil.readNullable(in, ByteBufUtil::readObjectId), ByteBufUtil.readObjectId(in), ByteBufUtil.readUtf8(in), ByteBufUtil.readVarInt(in), ByteBufUtil.readVarInt(in));
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Role)) return false;
        Role that = (Role)obj;
        if (!that.id.equals(this.id)) return false;
        return true;
    }

    @Override
    public int compareTo(Role o) {
        if (o.id.equals(this.id)) {
            return 0;
        }
        if (o.weight != this.weight) {
            return Integer.compare(this.weight, o.weight);
        }
        return this.id.compareTo(o.id);
    }
}

