/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.rocketpowered.common.ProjectPermission;
import org.jetbrains.annotations.Nullable;

public enum PunishmentType {
    BAN("ban", ProjectPermission.BAN, ProjectPermission.PARDON_BAN),
    MUTE("mute", ProjectPermission.MUTE, ProjectPermission.PARDON_MUTE);

    private static final Map<String, PunishmentType> byName;
    private final String name;
    private final ProjectPermission permission;
    private final ProjectPermission pardonPermission;

    private PunishmentType(String name, ProjectPermission permission, ProjectPermission pardonPermission) {
        this.name = name;
        this.permission = permission;
        this.pardonPermission = pardonPermission;
    }

    public ProjectPermission getPermission() {
        return this.permission;
    }

    public ProjectPermission getPardonPermission() {
        return this.pardonPermission;
    }

    public boolean isBan() {
        return this == BAN;
    }

    public boolean isMute() {
        return this == MUTE;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    @JsonCreator
    @Nullable
    public static PunishmentType getByName(String name) {
        return byName.get(name.toLowerCase());
    }

    static {
        byName = Arrays.stream(PunishmentType.values()).collect(Collectors.toMap(PunishmentType::getName, Function.identity()));
    }
}

