/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.common;

import io.netty.buffer.ByteBuf;
import java.time.Instant;
import net.rocketpowered.common.GameServer;
import net.rocketpowered.common.PunishmentType;
import net.rocketpowered.common.User;
import net.rocketpowered.common.util.ByteBufUtil;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.Nullable;

public record Punishment(ObjectId id, ObjectId projectId, PunishmentType type, User punished, User punisher, @Nullable GameServer server, @Nullable String reason, @Nullable Instant expiresAt, boolean pardoned) implements Comparable<Punishment>
{
    public boolean isActive() {
        return !this.isExpired() && !this.pardoned;
    }

    public boolean isExpired() {
        return this.expiresAt != null && this.expiresAt.isBefore(Instant.now());
    }

    public boolean expiresAfter(Punishment punishment) {
        return this.compareTo(punishment) > 0;
    }

    public boolean expiresBefore(Punishment punishment) {
        return this.compareTo(punishment) < 0;
    }

    @Override
    public int compareTo(Punishment o) {
        if (this.expiresAt == null && o.expiresAt == null) {
            return 0;
        }
        if (this.expiresAt == null) {
            return 1;
        }
        if (o.expiresAt == null) {
            return -1;
        }
        return this.expiresAt.compareTo(o.expiresAt);
    }

    public void encode(ByteBuf out) {
        ByteBufUtil.writeObjectId(this.id, out);
        ByteBufUtil.writeObjectId(this.projectId, out);
        ByteBufUtil.writeEnum(this.type, out);
        this.punished.encode(out);
        this.punisher.encode(out);
        ByteBufUtil.writeNullable(out, this.server, GameServer::encode);
        ByteBufUtil.writeNullable(out, this.reason, ByteBufUtil::writeUtf8);
        ByteBufUtil.writeNullable(out, this.expiresAt, ByteBufUtil::writeInstant);
        out.writeBoolean(this.pardoned);
    }

    public static Punishment decode(ByteBuf in) {
        return new Punishment(ByteBufUtil.readObjectId(in), ByteBufUtil.readObjectId(in), ByteBufUtil.readEnum(in, PunishmentType.class), User.decode(in), User.decode(in), ByteBufUtil.readNullable(in, GameServer::decode), ByteBufUtil.readNullable(in, ByteBufUtil::readUtf8), ByteBufUtil.readNullable(in, ByteBufUtil::readInstant), in.readBoolean());
    }
}

