/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.common;

import io.netty.buffer.ByteBuf;
import java.time.Instant;
import java.util.Objects;
import net.rocketpowered.common.PunishmentType;
import net.rocketpowered.common.util.ByteBufUtil;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.Nullable;

public record PunishRequest(ObjectId projectId, PunishmentType type, ObjectId punishedId, ObjectId punisherId, @Nullable ObjectId serverId, @Nullable String reason, @Nullable Instant expiresAt) {
    public void encode(ByteBuf out) {
        ByteBufUtil.writeObjectId(this.projectId, out);
        ByteBufUtil.writeEnum(this.type, out);
        ByteBufUtil.writeObjectId(this.punishedId, out);
        ByteBufUtil.writeObjectId(this.punisherId, out);
        ByteBufUtil.writeNullable(out, this.serverId, ByteBufUtil::writeObjectId);
        ByteBufUtil.writeNullable(out, this.reason, ByteBufUtil::writeUtf8);
        ByteBufUtil.writeNullable(out, this.expiresAt, ByteBufUtil::writeInstant);
    }

    public static PunishRequest decode(ByteBuf in) {
        return new PunishRequest(ByteBufUtil.readObjectId(in), ByteBufUtil.readEnum(in, PunishmentType.class), ByteBufUtil.readObjectId(in), ByteBufUtil.readObjectId(in), ByteBufUtil.readNullable(in, ByteBufUtil::readObjectId), ByteBufUtil.readNullable(in, ByteBufUtil::readUtf8), ByteBufUtil.readNullable(in, ByteBufUtil::readInstant));
    }

    public static Builder builder(ObjectId projectId) {
        return new Builder(projectId);
    }

    public static final class Builder {
        private final ObjectId projectId;
        private PunishmentType type;
        private ObjectId punished;
        private ObjectId punisher;
        @Nullable
        private ObjectId serverId;
        @Nullable
        private String reason;
        @Nullable
        private Instant expiresAt;

        private Builder(ObjectId projectId) {
            this.projectId = projectId;
        }

        public Builder punished(ObjectId punished) {
            this.punished = punished;
            return this;
        }

        public Builder punisher(ObjectId punisher) {
            this.punisher = punisher;
            return this;
        }

        public Builder serverId(ObjectId serverId) {
            this.serverId = serverId;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder type(PunishmentType type) {
            this.type = type;
            return this;
        }

        public PunishRequest build() {
            Objects.requireNonNull(this.punished, "punished cannot be null");
            Objects.requireNonNull(this.punisher, "punisher cannot be null");
            Objects.requireNonNull(this.type, "type cannot be null");
            return new PunishRequest(this.projectId, this.type, this.punished, this.punisher, this.serverId, this.reason, this.expiresAt);
        }
    }
}

