/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.rocketpowered.common.util.BitValue;

public enum ProjectPermission implements BitValue
{
    MUTE("mute", 1L),
    BAN("ban", 2L),
    MANAGE_PROJECT("manage_project", 4L),
    MANAGE_ROLES("manage_roles", 8L),
    VIEW_PUNISHMENTS("view_punishments", 16L),
    ADMINISTRATOR("administrator", 32L),
    PARDON_MUTE("pardon_mute", 64L),
    PARDON_BAN("pardon_ban", 128L);

    public static final long ALL;
    private static final Map<String, ProjectPermission> byName;
    private final String name;
    private final long bits;

    private ProjectPermission(String name, long bits) {
        this.name = name;
        this.bits = bits;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public long bits() {
        return this.bits;
    }

    public String toString() {
        return this.name;
    }

    public static Optional<ProjectPermission> getByName(String name) {
        return Optional.ofNullable(byName.get(name));
    }

    public static Collection<ProjectPermission> getPermissions(long value) {
        return BitValue.decode(value, ProjectPermission.class);
    }

    static {
        ALL = BitValue.encode(ProjectPermission.values());
        byName = Arrays.stream(ProjectPermission.values()).collect(Collectors.toMap(ProjectPermission::getName, Function.identity()));
    }
}

