/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.common;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.rocketpowered.common.util.ByteBufUtil;

public record MinecraftProfile(UUID id, String name) implements Comparable<MinecraftProfile>
{
    public void encode(ByteBuf out) {
        ByteBufUtil.writeUniqueId(this.id, out);
        ByteBufUtil.writeUtf8(this.name, out);
    }

    public static MinecraftProfile decode(ByteBuf in) {
        return new MinecraftProfile(ByteBufUtil.readUniqueId(in), ByteBufUtil.readUtf8(in));
    }

    @Override
    public int compareTo(MinecraftProfile o) {
        return this.name.compareTo(o.name);
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MinecraftProfile)) return false;
        MinecraftProfile that = (MinecraftProfile)obj;
        if (!that.id.equals(this.id)) return false;
        return true;
    }
}

