/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.common;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.rocketpowered.common.GuildPermission;
import net.rocketpowered.common.util.BitValue;
import org.jetbrains.annotations.Nullable;

public enum GuildRank {
    NONE("none", null, new GuildPermission[0]),
    ENVOY("envoy", "Envoy", GuildPermission.INVITE),
    DIGNITARY("dignitary", "Dignitary", GuildPermission.INVITE, GuildPermission.KICK, GuildPermission.MANAGE_REQUESTS, GuildPermission.MANAGE_RANKS);

    private static final Map<String, GuildRank> byName;
    private final String name;
    @Nullable
    private final String displayName;
    private final long defaultPermissions;

    private GuildRank(String name, String displayName, GuildPermission ... defaultPermissions) {
        this.name = name;
        this.displayName = displayName;
        this.defaultPermissions = BitValue.encode(defaultPermissions);
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getDisplayName() {
        return Optional.ofNullable(this.displayName);
    }

    public long getDefaultPermissions() {
        return this.defaultPermissions;
    }

    public String toString() {
        return this.name;
    }

    public boolean isHighest() {
        return this.ordinal() == GuildRank.values().length - 1;
    }

    public boolean isLowest() {
        return this.ordinal() == 0;
    }

    public GuildRank promote() {
        return GuildRank.values()[Math.min(this.ordinal() + 1, GuildRank.values().length - 1)];
    }

    public GuildRank demote() {
        return GuildRank.values()[Math.max(this.ordinal() - 1, 0)];
    }

    public static Optional<GuildRank> getByName(String name) {
        return Optional.ofNullable(byName.get(name));
    }

    static {
        byName = Arrays.stream(GuildRank.values()).collect(Collectors.toMap(GuildRank::getName, Function.identity()));
    }
}

