/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.rocketpowered.common.util.BitValue;

public enum GuildPermission implements BitValue
{
    KICK("kick", 1L),
    RENAME("rename", 2L),
    INVITE("invite", 4L),
    MANAGE_REQUESTS("manage_requests", 8L),
    MANAGE_RANKS("manage_ranks", 16L);

    public static final long ALL;
    private static final Map<String, GuildPermission> byName;
    private final String name;
    private final long bits;

    private GuildPermission(String name, long bits) {
        this.name = name;
        this.bits = bits;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public long bits() {
        return this.bits;
    }

    public String toString() {
        return this.name;
    }

    public static Optional<GuildPermission> getByName(String name) {
        return Optional.ofNullable(byName.get(name));
    }

    public static Collection<GuildPermission> getPermissions(long value) {
        return BitValue.decode(value, GuildPermission.class);
    }

    static {
        ALL = BitValue.encode(GuildPermission.values());
        byName = Arrays.stream(GuildPermission.values()).collect(Collectors.toMap(GuildPermission::getName, Function.identity()));
    }
}

