/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.common;

import io.netty.buffer.ByteBuf;
import net.rocketpowered.common.Guild;
import net.rocketpowered.common.User;
import net.rocketpowered.common.util.ByteBufUtil;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Mono;

public record GuildInvite(Guild guild, @Nullable User sender) {
    public Mono<User> senderMono() {
        return Mono.justOrEmpty(this.sender);
    }

    public void encode(ByteBuf out) {
        this.guild.encode(out);
        ByteBufUtil.writeNullable(out, this.sender, User::encode);
    }

    public static GuildInvite decode(ByteBuf in) {
        return new GuildInvite(Guild.decode(in), ByteBufUtil.readNullable(in, User::decode));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GuildInvite)) return false;
        GuildInvite that = (GuildInvite)obj;
        if (!that.guild.equals(this.guild)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.guild.hashCode();
    }
}

