/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.common;

import io.netty.buffer.ByteBuf;
import java.util.EnumMap;
import java.util.Map;
import net.rocketpowered.common.GuildMember;
import net.rocketpowered.common.GuildPermission;
import net.rocketpowered.common.GuildRank;
import net.rocketpowered.common.User;
import net.rocketpowered.common.util.ByteBufUtil;
import org.bson.types.ObjectId;

public record Guild(ObjectId id, User owner, String name, String tag, Map<GuildRank, Long> permissions) {
    public Guild(ObjectId id, User owner, String name, String tag, Map<GuildRank, Long> permissions) {
        this.id = id;
        this.owner = owner;
        this.name = name;
        this.tag = tag;
        this.permissions = Map.copyOf(permissions);
    }

    public long getPermissions(GuildMember member) {
        return this.isOwner(member) ? GuildPermission.ALL : this.getPermissions(member.rank());
    }

    public long getPermissions(ObjectId userId, GuildRank rank) {
        return this.owner.id().equals(userId) ? GuildPermission.ALL : this.getPermissions(rank);
    }

    public long getPermissions(GuildRank rank) {
        return this.permissions.getOrDefault((Object)rank, 0L);
    }

    public boolean isOwner(GuildMember member) {
        return this.isOwner(member.user());
    }

    public boolean isOwner(User user) {
        return this.owner.equals(user);
    }

    public void encode(ByteBuf out) {
        ByteBufUtil.writeObjectId(this.id, out);
        this.owner.encode(out);
        ByteBufUtil.writeUtf8(this.name, out);
        ByteBufUtil.writeUtf8(this.tag, out);
        ByteBufUtil.writeVarInt(this.permissions.size(), out);
        this.permissions.forEach((rank, permission) -> {
            ByteBufUtil.writeEnum(rank, out);
            ByteBufUtil.writeVarLong(permission, out);
        });
    }

    public static Guild decode(ByteBuf in) {
        ObjectId id = ByteBufUtil.readObjectId(in);
        User owner = User.decode(in);
        String name = ByteBufUtil.readUtf8(in);
        String tag = ByteBufUtil.readUtf8(in);
        EnumMap<GuildRank, Long> permissions = new EnumMap<GuildRank, Long>(GuildRank.class);
        int permissionsSize = ByteBufUtil.readVarInt(in);
        for (int i = 0; i < permissionsSize; ++i) {
            permissions.put(ByteBufUtil.readEnum(in, GuildRank.class), ByteBufUtil.readVarLong(in));
        }
        return new Guild(id, owner, name, tag, permissions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Guild)) return false;
        Guild that = (Guild)obj;
        if (!that.id.equals(this.id)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }
}

