/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.common;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.rocketpowered.common.util.ByteBufUtil;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.Nullable;

public record GameServer(@Nullable ObjectId id, ObjectId projectId, ObjectId ownerId, String name, @Nullable String token, boolean official) {
    public GameServer withoutToken() {
        return new GameServer(this.id, this.projectId, this.ownerId, this.name, null, this.official);
    }

    public void encode(ByteBuf out) {
        ByteBufUtil.writeNullable(out, this.id, ByteBufUtil::writeObjectId);
        ByteBufUtil.writeObjectId(this.projectId, out);
        ByteBufUtil.writeObjectId(this.ownerId, out);
        ByteBufUtil.writeUtf8(this.name, out);
        ByteBufUtil.writeNullable(out, this.token, ByteBufUtil::writeUtf8);
        out.writeBoolean(this.official);
    }

    public static GameServer decode(ByteBuf in) {
        return new GameServer(ByteBufUtil.readNullable(in, ByteBufUtil::readObjectId), ByteBufUtil.readObjectId(in), ByteBufUtil.readObjectId(in), ByteBufUtil.readUtf8(in), ByteBufUtil.readNullable(in, ByteBufUtil::readUtf8), in.readBoolean());
    }

    @Override
    public String toString() {
        return String.format("GameServer['%s'/%s, official='%s']", this.name, this.id.toHexString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof GameServer)) return false;
        GameServer that = (GameServer)obj;
        if (!that.id.equals(this.id)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id);
    }
}

