/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.common;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.rocketpowered.common.User;
import net.rocketpowered.common.util.ByteBufUtil;
import org.bson.types.ObjectId;

public record GameProfile(User user, ObjectId projectId, Set<ObjectId> roles) {
    private final Set<ObjectId> roles;

    public Set<ObjectId> roles() {
        return Collections.unmodifiableSet(this.roles);
    }

    public void encode(ByteBuf out) {
        this.user.encode(out);
        ByteBufUtil.writeObjectId(this.projectId, out);
        ByteBufUtil.writeVarInt(this.roles.size(), out);
        for (ObjectId roleId : this.roles) {
            ByteBufUtil.writeObjectId(roleId, out);
        }
    }

    public static GameProfile decode(ByteBuf in) {
        User user = User.decode(in);
        ObjectId projectId = ByteBufUtil.readObjectId(in);
        HashSet<ObjectId> roles = new HashSet<ObjectId>();
        int rolesSize = ByteBufUtil.readVarInt(in);
        for (int i = 0; i < rolesSize; ++i) {
            roles.add(ByteBufUtil.readObjectId(in));
        }
        return new GameProfile(user, projectId, roles);
    }
}

