/*
 * Decompiled with CFR 0.152.
 */
package net.rocketpowered.common;

import net.rocketpowered.common.RocketException;
import reactor.core.publisher.Mono;

public enum ErrorCode {
    ALREADY_IN_GUILD(0, "Already in a guild."),
    TAG_IN_USE(1, "Tag already in use."),
    MEMBER_ALREADY_ADDED(2, "Member already added."),
    NO_GUILD(3, "Don't own guild."),
    NOT_FOUND(4, "Resource not found."),
    FRIEND_REQUEST_ALREADY_EXISTS(5, "Friend request already exists."),
    FORBIDDEN(6, "Unauthorized to perform this action."),
    BAD_CREDENTIALS(7, "Bad credentials."),
    INTERNAL_SERVER_EXCEPTION(8, "This isn't supposed to happen..."),
    RESOURCE_DELETED(9, "Resource deleted."),
    BAD_REQUEST(10, "Bad request."),
    AUTHENTICATION_UNAVAILABLE(11, "Authentication unavailable.");

    private static final ErrorCode[] ERRORS;
    private final int code;
    private final String defaultMessage;

    private ErrorCode(int code, String defaultMessage) {
        this.code = code;
        this.defaultMessage = defaultMessage;
    }

    public int getCode() {
        return this.code;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public <T> Mono<T> toMono() {
        return Mono.error(this::toException);
    }

    public RocketException toException() {
        return new RocketException(this, this.defaultMessage);
    }

    public <T> Mono<T> toMono(String message) {
        return Mono.error(() -> this.toException(message));
    }

    public RocketException toException(String message) {
        return new RocketException(this, message);
    }

    public static ErrorCode fromCode(int code) {
        if (code < 0 || code >= ERRORS.length) {
            throw new IllegalArgumentException("Invalid error code: " + code);
        }
        return ERRORS[code];
    }

    static {
        ERRORS = new ErrorCode[ErrorCode.values().length];
        for (ErrorCode error : ErrorCode.values()) {
            if (ERRORS[error.code] != null) {
                throw new IllegalStateException("Duplicate error code: " + error.code);
            }
            ErrorCode.ERRORS[error.code] = error;
        }
    }
}

