/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.server;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.WebsocketDuplexConnection;
import io.rsocket.transport.netty.server.BaseWebsocketServerTransport;
import io.rsocket.transport.netty.server.CloseableChannel;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Objects;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.http.server.HttpServer;

public final class WebsocketServerTransport
extends BaseWebsocketServerTransport<WebsocketServerTransport, CloseableChannel> {
    private final HttpServer server;
    private HttpHeaders headers = new DefaultHttpHeaders();

    private WebsocketServerTransport(HttpServer server) {
        this.server = (HttpServer)serverConfigurer.apply(Objects.requireNonNull(server, "server must not be null"));
    }

    public static WebsocketServerTransport create(int port) {
        HttpServer httpServer = HttpServer.create().port(port);
        return WebsocketServerTransport.create(httpServer);
    }

    public static WebsocketServerTransport create(String bindAddress, int port) {
        Objects.requireNonNull(bindAddress, "bindAddress must not be null");
        HttpServer httpServer = HttpServer.create().host(bindAddress).port(port);
        return WebsocketServerTransport.create(httpServer);
    }

    public static WebsocketServerTransport create(InetSocketAddress address) {
        Objects.requireNonNull(address, "address must not be null");
        return WebsocketServerTransport.create(address.getHostName(), address.getPort());
    }

    public static WebsocketServerTransport create(HttpServer server) {
        Objects.requireNonNull(server, "server must not be null");
        return new WebsocketServerTransport(server);
    }

    public WebsocketServerTransport header(String name, String ... values) {
        if (values != null) {
            Arrays.stream(values).forEach(value -> this.headers.add(name, value));
        }
        return this;
    }

    @Override
    public Mono<CloseableChannel> start(ServerTransport.ConnectionAcceptor acceptor) {
        Objects.requireNonNull(acceptor, "acceptor must not be null");
        return this.server.handle((request, response) -> {
            response.headers(this.headers);
            return response.sendWebsocket((in, out) -> acceptor.apply(new WebsocketDuplexConnection((Connection)((Object)in))).then(out.neverComplete()), this.specBuilder.build());
        }).bind().map(CloseableChannel::new);
    }
}

