/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.client;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.rsocket.DuplexConnection;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.WebsocketDuplexConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.WebsocketClientSpec;
import reactor.netty.tcp.TcpClient;

public final class WebsocketClientTransport
implements ClientTransport {
    private static final String DEFAULT_PATH = "/";
    private final HttpClient client;
    private final String path;
    private HttpHeaders headers = new DefaultHttpHeaders();
    private final WebsocketClientSpec.Builder specBuilder = (WebsocketClientSpec.Builder)WebsocketClientSpec.builder().maxFramePayloadLength(0xFFFFFF);

    private WebsocketClientTransport(HttpClient client, String path) {
        Objects.requireNonNull(client, "HttpClient must not be null");
        Objects.requireNonNull(path, "path must not be null");
        this.client = client;
        this.path = path.startsWith(DEFAULT_PATH) ? path : DEFAULT_PATH + path;
    }

    public static WebsocketClientTransport create(int port) {
        return WebsocketClientTransport.create(TcpClient.create().port(port));
    }

    public static WebsocketClientTransport create(String bindAddress, int port) {
        return WebsocketClientTransport.create(TcpClient.create().host(bindAddress).port(port));
    }

    public static WebsocketClientTransport create(InetSocketAddress address) {
        Objects.requireNonNull(address, "address must not be null");
        return WebsocketClientTransport.create((TcpClient)TcpClient.create().remoteAddress(() -> address));
    }

    public static WebsocketClientTransport create(TcpClient client) {
        return new WebsocketClientTransport(HttpClient.from(client), DEFAULT_PATH);
    }

    public static WebsocketClientTransport create(URI uri) {
        Objects.requireNonNull(uri, "uri must not be null");
        boolean isSecure = uri.getScheme().equals("wss") || uri.getScheme().equals("https");
        TcpClient client = (isSecure ? TcpClient.create().secure() : TcpClient.create()).host(uri.getHost()).port(uri.getPort() == -1 ? (isSecure ? 443 : 80) : uri.getPort());
        return new WebsocketClientTransport(HttpClient.from(client), uri.getPath());
    }

    public static WebsocketClientTransport create(HttpClient client, String path) {
        return new WebsocketClientTransport(client, path);
    }

    public WebsocketClientTransport header(String name, String ... values) {
        if (values != null) {
            Arrays.stream(values).forEach(value -> this.headers.add(name, value));
        }
        return this;
    }

    public WebsocketClientTransport webSocketSpec(Consumer<WebsocketClientSpec.Builder> configurer) {
        configurer.accept(this.specBuilder);
        return this;
    }

    @Override
    public int maxFrameLength() {
        return this.specBuilder.build().maxFramePayloadLength();
    }

    @Override
    public Mono<DuplexConnection> connect() {
        return ((HttpClient.WebsocketSender)this.client.headers(headers -> headers.add(this.headers)).websocket(this.specBuilder.build()).uri(this.path)).connect().map(WebsocketDuplexConnection::new);
    }
}

