/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.client;

import io.netty.channel.ChannelHandler;
import io.rsocket.DuplexConnection;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.RSocketLengthCodec;
import io.rsocket.transport.netty.TcpDuplexConnection;
import java.net.InetSocketAddress;
import java.util.Objects;
import reactor.core.publisher.Mono;
import reactor.netty.tcp.TcpClient;

public final class TcpClientTransport
implements ClientTransport {
    private final TcpClient client;
    private final int maxFrameLength;

    private TcpClientTransport(TcpClient client, int maxFrameLength) {
        this.client = client;
        this.maxFrameLength = maxFrameLength;
    }

    public static TcpClientTransport create(int port) {
        TcpClient tcpClient = TcpClient.create().port(port);
        return TcpClientTransport.create(tcpClient);
    }

    public static TcpClientTransport create(String bindAddress, int port) {
        Objects.requireNonNull(bindAddress, "bindAddress must not be null");
        TcpClient tcpClient = TcpClient.create().host(bindAddress).port(port);
        return TcpClientTransport.create(tcpClient);
    }

    public static TcpClientTransport create(InetSocketAddress address) {
        Objects.requireNonNull(address, "address must not be null");
        reactor.netty.transport.ClientTransport tcpClient = TcpClient.create().remoteAddress(() -> address);
        return TcpClientTransport.create((TcpClient)tcpClient);
    }

    public static TcpClientTransport create(TcpClient client) {
        return TcpClientTransport.create(client, 0xFFFFFF);
    }

    public static TcpClientTransport create(TcpClient client, int maxFrameLength) {
        Objects.requireNonNull(client, "client must not be null");
        return new TcpClientTransport(client, maxFrameLength);
    }

    @Override
    public int maxFrameLength() {
        return this.maxFrameLength;
    }

    @Override
    public Mono<DuplexConnection> connect() {
        return ((TcpClient)this.client.doOnConnected(c -> c.addHandlerLast((ChannelHandler)((Object)new RSocketLengthCodec(this.maxFrameLength))))).connect().map(TcpDuplexConnection::new);
    }
}

