/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.plugins;

import io.netty.buffer.ByteBuf;
import io.rsocket.frame.FrameType;
import io.rsocket.plugins.RequestInterceptor;
import java.util.List;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

class CompositeRequestInterceptor
implements RequestInterceptor {
    final RequestInterceptor[] requestInterceptors;

    CompositeRequestInterceptor(RequestInterceptor[] requestInterceptors) {
        this.requestInterceptors = requestInterceptors;
    }

    @Override
    public void dispose() {
        RequestInterceptor[] requestInterceptors = this.requestInterceptors;
        for (int i = 0; i < requestInterceptors.length; ++i) {
            RequestInterceptor requestInterceptor = requestInterceptors[i];
            requestInterceptor.dispose();
        }
    }

    @Override
    public void onStart(int streamId, FrameType requestType, @Nullable ByteBuf metadata) {
        RequestInterceptor[] requestInterceptors = this.requestInterceptors;
        for (int i = 0; i < requestInterceptors.length; ++i) {
            RequestInterceptor requestInterceptor = requestInterceptors[i];
            try {
                requestInterceptor.onStart(streamId, requestType, metadata);
                continue;
            }
            catch (Throwable t) {
                Operators.onErrorDropped(t, Context.empty());
            }
        }
    }

    @Override
    public void onTerminate(int streamId, FrameType requestType, @Nullable Throwable cause) {
        RequestInterceptor[] requestInterceptors = this.requestInterceptors;
        for (int i = 0; i < requestInterceptors.length; ++i) {
            RequestInterceptor requestInterceptor = requestInterceptors[i];
            try {
                requestInterceptor.onTerminate(streamId, requestType, cause);
                continue;
            }
            catch (Throwable t) {
                Operators.onErrorDropped(t, Context.empty());
            }
        }
    }

    @Override
    public void onCancel(int streamId, FrameType requestType) {
        RequestInterceptor[] requestInterceptors = this.requestInterceptors;
        for (int i = 0; i < requestInterceptors.length; ++i) {
            RequestInterceptor requestInterceptor = requestInterceptors[i];
            try {
                requestInterceptor.onCancel(streamId, requestType);
                continue;
            }
            catch (Throwable t) {
                Operators.onErrorDropped(t, Context.empty());
            }
        }
    }

    @Override
    public void onReject(Throwable rejectionReason, FrameType requestType, @Nullable ByteBuf metadata) {
        RequestInterceptor[] requestInterceptors = this.requestInterceptors;
        for (int i = 0; i < requestInterceptors.length; ++i) {
            RequestInterceptor requestInterceptor = requestInterceptors[i];
            try {
                requestInterceptor.onReject(rejectionReason, requestType, metadata);
                continue;
            }
            catch (Throwable t) {
                Operators.onErrorDropped(t, Context.empty());
            }
        }
    }

    @Nullable
    static RequestInterceptor create(List<RequestInterceptor> interceptors) {
        switch (interceptors.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return new SafeRequestInterceptor(interceptors.get(0));
            }
        }
        return new CompositeRequestInterceptor(interceptors.toArray(new RequestInterceptor[0]));
    }

    static class SafeRequestInterceptor
    implements RequestInterceptor {
        final RequestInterceptor requestInterceptor;

        public SafeRequestInterceptor(RequestInterceptor requestInterceptor) {
            this.requestInterceptor = requestInterceptor;
        }

        @Override
        public void dispose() {
            this.requestInterceptor.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.requestInterceptor.isDisposed();
        }

        @Override
        public void onStart(int streamId, FrameType requestType, @Nullable ByteBuf metadata) {
            try {
                this.requestInterceptor.onStart(streamId, requestType, metadata);
            }
            catch (Throwable t) {
                Operators.onErrorDropped(t, Context.empty());
            }
        }

        @Override
        public void onTerminate(int streamId, FrameType requestType, @Nullable Throwable cause) {
            try {
                this.requestInterceptor.onTerminate(streamId, requestType, cause);
            }
            catch (Throwable t) {
                Operators.onErrorDropped(t, Context.empty());
            }
        }

        @Override
        public void onCancel(int streamId, FrameType requestType) {
            try {
                this.requestInterceptor.onCancel(streamId, requestType);
            }
            catch (Throwable t) {
                Operators.onErrorDropped(t, Context.empty());
            }
        }

        @Override
        public void onReject(Throwable rejectionReason, FrameType requestType, @Nullable ByteBuf metadata) {
            try {
                this.requestInterceptor.onReject(rejectionReason, requestType, metadata);
            }
            catch (Throwable t) {
                Operators.onErrorDropped(t, Context.empty());
            }
        }
    }
}

